/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.xml.XMLUtils;
import com.ibm.cognos.cm.fileSystemPlugin.io.DescriptorOutput;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorProperties;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.path.FileNameBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionDescriptorOutput
extends DescriptorOutput {
    private static final Log log = LogFactory.getLog(VersionDescriptorOutput.class);

    public VersionDescriptorOutput(String dir, DescriptorProperties props) throws RepositoryException {
        super(dir);
        this.setProperties(props);
        this.setName(FileNameBuilder.getVersionMetadataFileName(this.getProperties().getReportVersion()));
    }

    @Override
    protected void writeToBuffer(StringBuffer descriptorBuffer) throws RepositoryException {
        this.appendFileHeader(descriptorBuffer);
        descriptorBuffer.append("<versionDescriptor>\r\n");
        this.appendXmlProperty("reportStoreID", this.getProperties().getReportStoreID(), descriptorBuffer);
        this.appendXmlProperty("executionTime", this.getProperties().getExecutionTime(), descriptorBuffer);
        this.appendXmlProperty("reportSearchPath", XMLUtils.escape((String)this.getProperties().getReportSearchPath()), descriptorBuffer);
        TenantID tenantID = this.getProperties().getTenantID();
        this.appendXmlProperty("userTenantID", tenantID != null ? tenantID.toString() : "", descriptorBuffer);
        descriptorBuffer.append(this.getProperties().getOwner());
        descriptorBuffer.append("</versionDescriptor>\r\n");
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

