/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.metadata;

import com.cognos.cm.repositoryPluginAPI.DataObject;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IInputStreamPropertyValue;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.BurstEMailHelper;
import com.cognos.cm.repositoryPluginFramework.BurstHelper;
import com.cognos.cm.repositoryPluginFramework.SearchPathHelper;
import com.cognos.cmutils.date.DateUtils;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorProperties;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantIDProvider;
import com.ibm.cognos.cm.fileSystemPlugin.path.FileNameBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DescriptorPropertiesImpl
implements DescriptorProperties {
    private IDataDescriptor descriptor;
    private String fileName;
    private BurstHelper burstHelper;

    public DescriptorPropertiesImpl(IDataDescriptor metadata) {
        this.descriptor = metadata;
    }

    @Override
    public String getAsOfTime() throws RepositoryException {
        return this.getOptionalCalendarProperty("asOfTime");
    }

    @Override
    public String getBurstKey() throws RepositoryException {
        return this.getOptionalStringProperty("burstKey");
    }

    @Override
    public String getContentType() throws RepositoryException {
        return this.getOptionalStringProperty("contentType");
    }

    @Override
    public String getDefaultDescription() throws RepositoryException {
        return this.getStringProperty("defaultDescription");
    }

    @Override
    public String getDefaultName() throws RepositoryException {
        return this.getStringProperty("defaultName");
    }

    @Override
    public String getDocumentObjectID() throws RepositoryException {
        return this.getStringProperty("documentObjectID");
    }

    @Override
    public String getDocumentObjectClass() throws RepositoryException {
        return this.getStringProperty("documentObjectClass");
    }

    @Override
    public String getExecutionTime() throws RepositoryException {
        return this.getCalendarProperty("executionTime");
    }

    @Override
    public String getFormat() throws RepositoryException {
        return this.getOptionalStringProperty("format");
    }

    @Override
    public String getLocale() throws RepositoryException {
        return this.getStringProperty("locale");
    }

    @Override
    public String getReportOutputId() throws RepositoryException {
        return this.removeChar(this.getStringProperty("reportOutputID"), ':');
    }

    @Override
    public String getReportOutputStoreID() throws RepositoryException {
        return this.getStringProperty("reportOutputStoreID");
    }

    @Override
    public String getReportSearchPath() throws RepositoryException {
        return this.getStringProperty("reportSearchPath");
    }

    @Override
    public String getReportStoreID() throws RepositoryException {
        return this.getStringProperty("reportStoreID");
    }

    @Override
    public TenantID getTenantID() throws RepositoryException {
        String tenantIDString = this.getOptionalStringProperty("userTenantID");
        TenantIDProvider provider = new TenantIDProvider();
        return provider.get(tenantIDString);
    }

    @Override
    public String getReportVersion() throws RepositoryException {
        return this.removeChar(this.getStringProperty("reportVersionDefaultName"), ':');
    }

    @Override
    public String getReportVersionTimeStamp() throws RepositoryException {
        return this.getCalendarProperty("executionTime");
    }

    @Override
    public boolean hasPolicies() {
        return this.descriptor.getProperty("policies") != null;
    }

    @Override
    public byte[] getPolicies() throws RepositoryException {
        return this.getStringProperty("policies").getBytes();
    }

    @Override
    public InputStream getData() throws RepositoryException {
        DataObject dataObject = this.getDataObject();
        if (dataObject == null) {
            return null;
        }
        return dataObject.getDataStream();
    }

    @Override
    public String getDataLength() throws RepositoryException {
        DataObject dataObject = this.getDataObject();
        if (dataObject == null) {
            return "0";
        }
        return Long.toString(dataObject.getDataLength());
    }

    @Override
    public boolean hasSpecification() {
        IDataDescriptorProperty property = this.descriptor.getProperty("specification");
        return property != null;
    }

    @Override
    public InputStream getSpecification() throws RepositoryException {
        IDataDescriptorProperty property = this.descriptor.getProperty("specification");
        if (property == null) {
            return null;
        }
        Object input = property.getValue();
        if (input == null || input instanceof String && ((String)input).length() == 0) {
            return null;
        }
        if (input instanceof IInputStreamPropertyValue) {
            return ((IInputStreamPropertyValue)input).getStream();
        }
        throw new IllegalStateException("The following property has an unsupported type: specification");
    }

    @Override
    public String getFileName() throws RepositoryException {
        if (this.fileName == null) {
            this.fileName = FileNameBuilder.getFileName(this);
        }
        return this.fileName;
    }

    protected String getStringProperty(String name) throws RepositoryException {
        return this.getProperty(name).getStringValue();
    }

    protected String getOptionalStringProperty(String name) {
        IDataDescriptorProperty property = this.getOptionalProperty(name);
        if (property == null) {
            return "";
        }
        return property.getStringValue();
    }

    protected String getCalendarProperty(String name) throws RepositoryException {
        IDataDescriptorProperty property = this.getProperty(name);
        return this.formatCalendarProperty(property);
    }

    protected String getOptionalCalendarProperty(String name) {
        IDataDescriptorProperty property = this.getOptionalProperty(name);
        if (property == null) {
            return "";
        }
        return this.formatCalendarProperty(property);
    }

    private String formatCalendarProperty(IDataDescriptorProperty property) {
        return DateUtils.getIsoDate((Calendar)((Calendar)property.getValue()));
    }

    private IDataDescriptorProperty getProperty(String name) throws RepositoryException {
        IDataDescriptorProperty property = this.descriptor.getProperty(name);
        if (property == null) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.missingProperty).param("property", name);
            throw new RepositoryException(msg);
        }
        return property;
    }

    private IDataDescriptorProperty getOptionalProperty(String name) {
        return this.descriptor.getProperty(name);
    }

    private String removeChar(String s, char c) {
        StringBuffer r = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r.append(s.charAt(i));
        }
        return r.toString();
    }

    protected String getArrayPropertyAsXMLString(String name) {
        String arrayValue = "";
        IDataDescriptorProperty property = this.getOptionalProperty(name);
        if (property != null) {
            arrayValue = property.getStringValue();
            arrayValue = this.removeXMLVersionDeclaration(arrayValue);
        }
        return arrayValue;
    }

    private String removeXMLVersionDeclaration(String arrayValue) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        int indexOf = arrayValue.indexOf(xml);
        if (indexOf != -1) {
            arrayValue = arrayValue.substring(indexOf + xml.length());
        }
        return arrayValue;
    }

    @Override
    public String getRecipients() throws RepositoryException {
        return this.getArrayPropertyAsXMLString("recipients");
    }

    @Override
    public String getOwner() throws RepositoryException {
        return this.getArrayPropertyAsXMLString("owner");
    }

    @Override
    public boolean hasRecipients() throws RepositoryException {
        IDataDescriptorProperty recipientsProp = this.getOptionalProperty("recipients");
        return recipientsProp != null && recipientsProp.getStringValue().length() > 0;
    }

    @Override
    public boolean hasRecipientsEMail() throws RepositoryException {
        IDataDescriptorProperty recipientsEMailProp = this.getOptionalProperty("recipientsEMail");
        return recipientsEMailProp != null && recipientsEMailProp.getStringValue().length() > 0;
    }

    @Override
    public List<String> getRecipientsList() throws RepositoryException {
        if (this.burstHelper == null) {
            if (this.hasRecipients()) {
                this.burstHelper = new SearchPathHelper(this.getProperty("recipients").getStringValue());
            } else if (this.hasRecipientsEMail()) {
                this.burstHelper = new BurstEMailHelper(this.getProperty("recipientsEMail").getStringValue());
            } else {
                return new ArrayList<String>();
            }
        }
        return this.burstHelper.getValues();
    }

    @Override
    public boolean isBurst() throws RepositoryException {
        return this.hasRecipients() || this.hasRecipientsEMail();
    }

    private DataObject getDataObject() {
        DataObject dataObject = null;
        Object valueObject = this.descriptor.getProperty("data").getValue();
        if (valueObject instanceof DataObject) {
            dataObject = (DataObject)valueObject;
        }
        return dataObject;
    }
}

