/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.path;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.BurstHelper;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorProperties;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilePathBuilder {
    private static final Log log = LogFactory.getLog(FilePathBuilder.class);
    private static final String OR = "|";
    private static final String INVALID_CHARACTERS_REGEX = "[<>:\"\\|\\?\\*]";
    private static final String RESERVED_DIR_NAMES_REGEX = "^\\.\\.?$";
    private static final String INVALID_CHARACTER_SEQUENCES_REGEX = "(\\.\\.?[/\\\\])";
    private static final String VALIDATION_REGEX = "[<>:\"\\|\\?\\*]|(\\.\\.?[/\\\\])|^\\.\\.?$";
    private static final Pattern VALIDATION_PATTERN = Pattern.compile("[<>:\"\\|\\?\\*]|(\\.\\.?[/\\\\])|^\\.\\.?$");
    private static final String CHAR_REMOVED_MSG = "Some characters have been removed from the report folder name as they might not be supported by the operating system: ";
    public static final String FILES_FOLDER_SUFFIX = "_files";
    private static final char[] INVALID_CHARS = new char[]{':', '/', '\\', '?', '\"', '*', '<', '>', '|'};

    private FilePathBuilder() {
    }

    public static boolean isValidDirectoryName(String directoryName) {
        boolean isValid = false;
        if (directoryName != null && !directoryName.isEmpty()) {
            Matcher matcher = VALIDATION_PATTERN.matcher(directoryName);
            return !matcher.find();
        }
        return isValid;
    }

    public static String getDataDirectoryPath(String repositoryBase, String subDirectory, DescriptorProperties props) throws RepositoryException {
        String storeId = props.getReportStoreID();
        String executionTime = props.getReportVersionTimeStamp();
        TenantID tenantID = props.getTenantID();
        return FilePathBuilder.getDataDirectoryPath(repositoryBase, subDirectory, tenantID, storeId, executionTime);
    }

    public static String getRepositoryRootDirectory(String repositoryBase, String subDirectory, TenantID tenantID) {
        String pathSafeTenantID;
        StringBuilder newPath = new StringBuilder(repositoryBase);
        String string = pathSafeTenantID = tenantID == null ? null : tenantID.getPathSafeValue();
        if (FilePathBuilder.needsAppending(subDirectory) || FilePathBuilder.needsAppending(pathSafeTenantID)) {
            FilePathBuilder.addSeperator(repositoryBase, newPath);
            if (FilePathBuilder.needsAppending(pathSafeTenantID)) {
                newPath.append(pathSafeTenantID);
            }
            if (FilePathBuilder.needsAppending(subDirectory)) {
                FilePathBuilder.addSeperator(pathSafeTenantID, newPath);
                newPath.append(subDirectory);
            }
        }
        return newPath.toString();
    }

    private static void addSeperator(String previousStep, StringBuilder newPath) {
        if (previousStep != null && !previousStep.endsWith(File.separator)) {
            newPath.append(File.separatorChar);
        }
    }

    private static boolean needsAppending(String step) {
        return step != null && !step.isEmpty();
    }

    public static String getReportDirectoryPath(String repositoryBase, String subFolder, TenantID tenantID, String reportStoreId) {
        StringBuilder reportDirPath = new StringBuilder();
        reportDirPath.append(FilePathBuilder.getRepositoryRootDirectory(repositoryBase, subFolder, tenantID));
        FilePathBuilder.appendReportDirectoryPath(reportStoreId, reportDirPath);
        return reportDirPath.toString();
    }

    public static StringBuilder appendReportDirectoryPath(String reportStoreId, StringBuilder pathBuffer) {
        pathBuffer.append(File.separatorChar);
        pathBuffer.append(reportStoreId);
        return pathBuffer;
    }

    public static String getBurstDirectoryPath(String dataPath, String recipientCAMID) throws RepositoryException {
        return FilePathBuilder.getBurstDirectoryPath(dataPath, recipientCAMID, File.separatorChar);
    }

    public static String getBurstDirectoryPath(String dataPath, String recipientCAMID, char separatorChar) throws RepositoryException {
        byte[] recipientBytes = recipientCAMID.getBytes();
        String fan = BurstHelper.getDirectoryFan((String)recipientCAMID);
        String dirName = BurstHelper.getDirectoryName((byte[])recipientBytes);
        StringBuilder burstDirectoryPath = new StringBuilder();
        burstDirectoryPath.append(dataPath).append(separatorChar);
        burstDirectoryPath.append(fan.charAt(0)).append(separatorChar);
        burstDirectoryPath.append(fan.charAt(1)).append(separatorChar);
        burstDirectoryPath.append(fan.charAt(2)).append(separatorChar);
        burstDirectoryPath.append(dirName);
        return burstDirectoryPath.toString();
    }

    public static String getDataDirectoryPath(String repositoryBase, String subFolder, TenantID tenantID, String reportStoreId, String executionTime) {
        StringBuilder dataDirPath = new StringBuilder();
        dataDirPath.append(FilePathBuilder.getReportDirectoryPath(repositoryBase, subFolder, tenantID, reportStoreId));
        int idx1 = executionTime.indexOf(45);
        int idx2 = executionTime.indexOf(45, idx1 + 1);
        int idx3 = executionTime.indexOf(84);
        if (idx1 == -1 || idx2 == -1 || idx3 == -1) {
            throw new IllegalStateException("Unable to parse reportVersionCreationTime:" + executionTime);
        }
        dataDirPath.append(File.separatorChar);
        dataDirPath.append(executionTime.substring(0, idx1));
        dataDirPath.append(File.separatorChar);
        dataDirPath.append(executionTime.substring(idx1 + 1, idx2));
        dataDirPath.append(File.separatorChar);
        dataDirPath.append(executionTime.substring(idx2 + 1, idx3));
        dataDirPath.append(File.separatorChar);
        dataDirPath.append(executionTime.replace(":", ""));
        return dataDirPath.toString();
    }

    public static String getFilesDirectoryPath(String dataDirPath, String outpudId) {
        StringBuilder filesDirPath = new StringBuilder();
        filesDirPath.append(dataDirPath);
        filesDirPath.append(File.separatorChar);
        filesDirPath.append(outpudId);
        filesDirPath.append(FILES_FOLDER_SUFFIX);
        return filesDirPath.toString();
    }

    public static String getVersionDirectoryPath(String dataDirPath) {
        StringBuilder sbVersionFolder = new StringBuilder(dataDirPath);
        for (int i = 0; i < 4; ++i) {
            sbVersionFolder.append(File.separatorChar).append("..");
        }
        return sbVersionFolder.toString();
    }

    public static void createDirectory(String path) throws RepositoryException {
        File directory = new File(path);
        if (!directory.exists()) {
            try {
                FileUtils.forceMkdir((File)directory);
            }
            catch (IOException e) {
                Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.failedToWriteFile).param("fileName", path);
                msg.addDetail(e.getMessage());
                throw new RepositoryException(msg, (Throwable)e);
            }
        }
    }

    static String removeSpecialCharacters(String str) {
        HashSet<Character> charsRemoved = new HashSet<Character>();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!FilePathBuilder.isInvalidCharacter(chars[i])) continue;
            charsRemoved.add(Character.valueOf(chars[i]));
            chars[i] = 95;
        }
        if (charsRemoved.size() > 0) {
            log.debug((Object)(CHAR_REMOVED_MSG + charsRemoved.toString()));
        }
        return new String(chars);
    }

    private static boolean isInvalidCharacter(char ch) {
        return Arrays.binarySearch(INVALID_CHARS, ch) >= 0;
    }

    static {
        Arrays.sort(INVALID_CHARS);
    }
}

