/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndexFactory;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputContentBaseQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputID;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputContentQuery
extends OutputContentBaseQuery {
    private static final Log log = LogFactory.getLog(OutputContentQuery.class);

    public OutputContentQuery(FileSystemArchive archive, TenantID t) {
        super(archive, t);
    }

    OutputContentQuery(FileSystemArchive archive, TenantID t, BurstIndexFactory burstIndexFactory) {
        super(archive, t, burstIndexFactory);
    }

    @Override
    public List<IDataDescriptor> executeQuery(IQueryParameters parameters) throws RepositoryException {
        String outputObjectID = (String)parameters.getParameter("outputObjectID").getValue();
        return this.getOutput(outputObjectID);
    }

    protected List<IDataDescriptor> getOutput(String outputObjectID) throws RepositoryException {
        Map<String, String> metadata = this.loadMetadata(outputObjectID);
        ArrayList<IDataDescriptor> dataDescriptorArray = new ArrayList<IDataDescriptor>();
        DataDescriptorProperty[] outputData = this.getOutputData(metadata, outputObjectID);
        this.addToDescriptorList(dataDescriptorArray, outputData);
        return dataDescriptorArray;
    }

    protected DataDescriptorProperty[] getOutputData(Map<String, String> metadata, String outputObjectID) throws RepositoryException {
        String outputFilename = this.getOutputFilename(metadata, outputObjectID);
        File f = new File(outputFilename);
        DataDescriptorProperty[] outputData = new DataDescriptorProperty[3 + metadata.size()];
        outputData[0] = new DataDescriptorProperty("headers", this.getResponseHeaders(this.getContentType(metadata), this.getLocale(metadata), this.getContentDispositionFilename(metadata), this.getDataLength(metadata)));
        outputData[1] = new DataDescriptorProperty("contentStream", (Object)this.getInputStream(f));
        outputData[2] = new DataDescriptorProperty("objectID", (Object)outputObjectID);
        this.addMetadata(outputData, 3, metadata);
        return outputData;
    }

    private String getOutputFilename(Map<String, String> metadata, String outputObjectID) throws RepositoryException {
        StringBuilder sbPathname = new StringBuilder(this.getAliasRoot());
        OutputID outputID = OutputID.valueOf(outputObjectID);
        outputID.processFilePath(sbPathname);
        sbPathname.append(this.getFileNameExtension(metadata));
        return sbPathname.toString();
    }

    private String getContentDispositionFilename(Map<String, String> metadata) {
        StringBuilder sbFilename = new StringBuilder();
        sbFilename.append(metadata.get("defaultName"));
        sbFilename.append(this.getFileNameExtension(metadata));
        return sbFilename.toString();
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

