/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndexFactory;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputContentBaseQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputID;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputFileContentQuery
extends OutputContentBaseQuery {
    private static final Log log = LogFactory.getLog(OutputFileContentQuery.class);

    public OutputFileContentQuery(FileSystemArchive archive, TenantID t) {
        super(archive, t);
    }

    OutputFileContentQuery(FileSystemArchive archive, TenantID t, BurstIndexFactory burstIndexFactory) {
        super(archive, t, burstIndexFactory);
    }

    @Override
    public List<IDataDescriptor> executeQuery(IQueryParameters parameters) throws RepositoryException {
        String outputObjectID = this.getParameter(parameters, "outputObjectID");
        String outputFileName = this.getParameter(parameters, "outputFileName");
        return this.getGraphic(outputObjectID, outputFileName);
    }

    protected List<IDataDescriptor> getGraphic(String outputObjectID, String outputFileName) throws RepositoryException {
        ArrayList<IDataDescriptor> dataDescriptorList = new ArrayList<IDataDescriptor>();
        DataDescriptorProperty[] graphicData = this.getGraphicData(outputObjectID, outputFileName);
        this.addToDescriptorList(dataDescriptorList, graphicData);
        return dataDescriptorList;
    }

    protected DataDescriptorProperty[] getGraphicData(String outputObjectID, String outputFileName) throws RepositoryException {
        OutputID outputID = this.createOutputID(outputObjectID, outputFileName);
        Map<String, String> graphicMetadata = this.loadGraphicMetadata(outputID, outputFileName);
        String graphicsFilename = this.getGraphicFilename(outputID, outputFileName, graphicMetadata);
        File f = new File(graphicsFilename);
        DataDescriptorProperty[] outputData = new DataDescriptorProperty[]{new DataDescriptorProperty("headers", this.getResponseHeaders(this.getContentType(graphicMetadata), this.getLocale(graphicMetadata), f.getName(), this.getDataLength(graphicMetadata))), new DataDescriptorProperty("contentStream", (Object)this.getInputStream(f)), new DataDescriptorProperty("objectID", (Object)outputFileName)};
        return outputData;
    }

    private String getGraphicFilename(OutputID outputID, String outputFileName, Map<String, String> graphicMetadata) throws RepositoryException {
        StringBuilder sbPathname = new StringBuilder(this.getAliasRoot());
        outputID.processFilePathNoLocale(sbPathname);
        sbPathname.append("_files").append(File.separator).append(outputFileName);
        sbPathname.append(this.getFileNameExtension(graphicMetadata));
        return sbPathname.toString();
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

