/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.io.BurstIndexFactory;
import com.ibm.cognos.cm.fileSystemPlugin.io.DataDescriptorInput;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputContentBaseQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputID;
import com.ibm.cognos.cm.fileSystemPlugin.query.QueryParameterValidator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputFileReportQuery
extends OutputContentBaseQuery {
    private static final Log log = LogFactory.getLog(OutputFileReportQuery.class);

    public OutputFileReportQuery(FileSystemArchive fileSystemArchive, TenantID t) {
        super(fileSystemArchive, t);
    }

    OutputFileReportQuery(FileSystemArchive fileSystemArchive, TenantID t, BurstIndexFactory burstIndexFactory) {
        super(fileSystemArchive, t, burstIndexFactory);
    }

    @Override
    public List<IDataDescriptor> executeQuery(IQueryParameters parameters) throws RepositoryException {
        IQueryParameter param_outputObjectID = parameters.getParameter("outputObjectID");
        IQueryParameter param_outputFileName = parameters.getParameter("outputFileName");
        this.validateParameters(param_outputObjectID, param_outputFileName);
        String outputObjectID = (String)param_outputObjectID.getValue();
        String outputFileName = (String)param_outputFileName.getValue();
        OutputID outputID = this.createOutputID(outputObjectID, outputFileName);
        String graphicMetadataFilename = this.getGraphicMetadataFilename(outputID, outputFileName);
        if (new File(graphicMetadataFilename).exists()) {
            Map<String, String> graphicMetadata = this.loadGraphicMetadata(graphicMetadataFilename);
            return this.getGraphicMetadataDescriptor(graphicMetadata);
        }
        return Collections.emptyList();
    }

    protected List<IDataDescriptor> getGraphicMetadataDescriptor(Map<String, String> graphicMetadata) {
        ArrayList<IDataDescriptor> dataDescriptorArray = new ArrayList<IDataDescriptor>();
        if (graphicMetadata != null) {
            this.addToDataDescriptorArray(dataDescriptorArray, graphicMetadata);
        }
        return dataDescriptorArray;
    }

    protected Map<String, String> loadGraphicMetadata(String graphicMetadataFilename) throws RepositoryException {
        DataDescriptorInput metadataInput = new DataDescriptorInput();
        return metadataInput.readMetadataFromFile(new File(graphicMetadataFilename));
    }

    private void validateParameters(IQueryParameter param_outputObjectID, IQueryParameter param_outputFileName) throws RepositoryException {
        QueryParameterValidator.validateNonEmptyString(log, "outputObjectID", param_outputObjectID);
        QueryParameterValidator.validateNonEmptyString(log, "outputFileName", param_outputFileName);
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

