/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.path.FilePathBuilder;
import com.ibm.cognos.cm.fileSystemPlugin.query.VersionID;
import com.ibm.cognos.cm.repositoryplugincommon.XMLGregorianCalendarProvider;
import java.util.Base64;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class OutputID
extends VersionID {
    private String reportOutputStoreID;
    private String locale;
    private String burstRecipient;

    public OutputID(String reportId, String versionTimeStamp, String reportOutputStoreID, String locale) throws RepositoryException {
        this(new String[]{reportId, versionTimeStamp, reportOutputStoreID, locale});
    }

    public OutputID(String reportId, String versionTimeStamp, String reportOutputStoreID, String locale, String burstRecipient) throws RepositoryException {
        this(new String[]{reportId, versionTimeStamp, reportOutputStoreID, locale});
        this.burstRecipient = burstRecipient;
    }

    OutputID(String[] idTokens) throws RepositoryException {
        super(idTokens);
    }

    @Override
    protected void processIDTokens(String[] parts) throws RepositoryException {
        super.processIDTokens(parts);
        this.reportOutputStoreID = parts[2];
        this.locale = parts[3];
        if (parts.length == 5) {
            this.setRecipient(parts[4]);
        }
    }

    private void setRecipient(String recipientPart) {
        this.burstRecipient = new String(Base64.getDecoder().decode(recipientPart.getBytes(Charsets.UTF_8)), Charsets.UTF_8);
    }

    @Override
    protected void processFilePath(StringBuilder buffer) throws RepositoryException {
        this.processFilePathNoLocale(buffer);
        buffer.append('-').append(this.locale);
    }

    protected void processFilePathNoLocale(StringBuilder buffer) throws RepositoryException {
        try {
            super.processFilePath(buffer);
            if (this.isBursted()) {
                buffer.append(FilePathBuilder.getBurstDirectoryPath("", this.burstRecipient, IOUtils.DIR_SEPARATOR));
            }
            buffer.append(IOUtils.DIR_SEPARATOR);
            buffer.append(this.reportOutputStoreID);
        }
        catch (Exception e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    @Override
    protected void buildID(StringBuilder builder) throws RepositoryException {
        super.buildID(builder);
        builder.append("_");
        builder.append(this.reportOutputStoreID);
        builder.append("_");
        builder.append(this.locale);
        if (this.isBursted()) {
            this.appendBurstRecipient(builder);
        }
    }

    private void appendBurstRecipient(StringBuilder builder) {
        builder.append("_");
        builder.append(new String(Base64.getEncoder().encode(this.burstRecipient.getBytes(Charsets.UTF_8)), Charsets.UTF_8));
    }

    public OutputID(String versionID, Map<String, String> metaData) throws RepositoryException {
        super((String[])null);
        this.populateFromMetaData(versionID, metaData);
    }

    private void populateFromMetaData(String versionID, Map<String, String> metaData) {
        this.setReportStoreID(metaData.get("reportStoreID"));
        this.reportOutputStoreID = metaData.get("reportOutputStoreID");
        this.locale = metaData.get("locale");
        this.setTimeStamp(XMLGregorianCalendarProvider.parse((String)versionID));
        this.burstRecipient = metaData.get("burstRecipient");
    }

    public String getOutputStoreID() {
        return this.reportOutputStoreID;
    }

    public String getBurstRecipient() {
        return this.burstRecipient;
    }

    public boolean isBursted() {
        return this.burstRecipient != null;
    }

    public String getLocale() {
        return this.locale;
    }

    public static OutputID valueOf(String id) throws RepositoryException {
        try {
            String[] idTokens = OutputID.tokenizeIdString(id);
            return new OutputID(idTokens);
        }
        catch (Exception e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    void setBurstRecipient(String burstRecipient) {
        this.burstRecipient = burstRecipient;
    }

    void clearBurstRecipient() {
        this.burstRecipient = null;
    }
}

