/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepositoryErrors;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantIDProvider;
import com.ibm.cognos.cm.fileSystemPlugin.query.FileSystemQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputContentQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputFileContentQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputFileReportQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.OutputReport;
import com.ibm.cognos.cm.fileSystemPlugin.query.QueryResultsSorter;
import com.ibm.cognos.cm.fileSystemPlugin.query.ReportOutputQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.ReportVersionsQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.VersionOutputQuery;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryProcessor {
    private FileSystemArchive archive;
    protected static final Map<String, Class<? extends FileSystemQuery>> QUERIES = new HashMap<String, Class<? extends FileSystemQuery>>();

    public QueryProcessor(FileSystemArchive fileSystemArchive) {
        this.archive = fileSystemArchive;
    }

    public List<IDataDescriptor> processQuery(String queryName, IQueryParameters parameters) throws RepositoryException {
        Class<? extends FileSystemQuery> queryObject = QUERIES.get(queryName);
        if (queryObject == null) {
            Message msg = new Message((Resource.Id)FileSystemRepositoryErrors.FRP_OPF.unrecognizedQueryName).param("name", queryName);
            throw new RepositoryException(msg);
        }
        FileSystemQuery queryObjectInstance = null;
        IQueryParameter param_tenantID = parameters.getParameter("connectionTenantID");
        TenantID tenantID = param_tenantID != null ? new TenantIDProvider().get((String)param_tenantID.getValue()) : null;
        try {
            Constructor<? extends FileSystemQuery> constructor = queryObject.getConstructor(FileSystemArchive.class, TenantID.class);
            queryObjectInstance = constructor.newInstance(this.archive, tenantID);
        }
        catch (Exception e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
        List<IDataDescriptor> queryResults = queryObjectInstance.executeQuery(parameters);
        this.sortResults(parameters, queryResults);
        return queryResults;
    }

    private void sortResults(IQueryParameters parameters, List<IDataDescriptor> queryResults) {
        QueryResultsSorter sorter = new QueryResultsSorter();
        sorter.sort(queryResults, parameters);
    }

    static {
        QUERIES.put("getOutputContent", OutputContentQuery.class);
        QUERIES.put("getOutputFileContent", OutputFileContentQuery.class);
        QUERIES.put("getOutputReport", OutputReport.class);
        QUERIES.put("getOutputFileReport", OutputFileReportQuery.class);
        QUERIES.put("getVersionOutputs", VersionOutputQuery.class);
        QUERIES.put("getReportVersionsBetweenTime", ReportVersionsQuery.class);
        QUERIES.put("getReportOutputs", ReportOutputQuery.class);
    }
}

