/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.path.FilePathBuilder;
import com.ibm.cognos.cm.fileSystemPlugin.query.FileSystemID;

public class ReportID
implements FileSystemID {
    public static final String TOKEN = "_";
    private static final String[] EMPTY_TOKEN_ARRAY = new String[0];
    private String reportStoreID;

    public ReportID(String reportStoreID) throws RepositoryException {
        this(new String[]{reportStoreID});
    }

    ReportID(String[] idTokens) throws RepositoryException {
        if (idTokens == null) {
            return;
        }
        try {
            this.processIDTokens(idTokens);
        }
        catch (Exception e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    public final String getReportStoreID() {
        return this.reportStoreID;
    }

    protected void processIDTokens(String[] parts) throws RepositoryException {
        if (parts.length == 0) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError);
        }
        this.reportStoreID = parts[0];
    }

    @Override
    public final String getFilePath() throws RepositoryException {
        try {
            StringBuilder buffer = new StringBuilder();
            this.processFilePath(buffer);
            return buffer.toString();
        }
        catch (Exception e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    protected void processFilePath(StringBuilder buffer) throws RepositoryException {
        FilePathBuilder.appendReportDirectoryPath(this.reportStoreID, buffer);
    }

    @Override
    public final String toString() {
        try {
            StringBuilder builder = new StringBuilder();
            this.buildID(builder);
            return builder.toString();
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void buildID(StringBuilder builder) throws RepositoryException {
        builder.append(this.reportStoreID);
    }

    protected static String[] tokenizeIdString(String id) {
        if (id != null) {
            return id.split(TOKEN);
        }
        return EMPTY_TOKEN_ARRAY;
    }

    public static ReportID valueOf(String id) throws RepositoryException {
        try {
            String[] idTokens = ReportID.tokenizeIdString(id);
            return new ReportID(idTokens);
        }
        catch (Exception e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    void setReportStoreID(String reportStoreID) {
        this.reportStoreID = reportStoreID;
    }
}

