/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemArchive;
import com.ibm.cognos.cm.fileSystemPlugin.FileSystemRepository;
import com.ibm.cognos.cm.fileSystemPlugin.io.DirectorySorter;
import com.ibm.cognos.cm.fileSystemPlugin.io.DirectorySorterFactory;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.FileSystemDataDescriptor;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.TenantID;
import com.ibm.cognos.cm.fileSystemPlugin.path.FileNameBuilder;
import com.ibm.cognos.cm.fileSystemPlugin.query.DateHolder;
import com.ibm.cognos.cm.fileSystemPlugin.query.DateRange;
import com.ibm.cognos.cm.fileSystemPlugin.query.FileSystemQuery;
import com.ibm.cognos.cm.fileSystemPlugin.query.QueryResultList;
import com.ibm.cognos.cm.fileSystemPlugin.query.ReportID;
import com.ibm.cognos.cm.fileSystemPlugin.query.VersionID;
import com.ibm.cognos.cm.repositoryplugincommon.XMLGregorianCalendarProvider;
import java.io.File;
import java.util.Calendar;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

class ReportVersionsQuery
implements FileSystemQuery {
    private static final int YEAR_LEVEL = 0;
    private static final int MONTH_LEVEL = 1;
    private static final int DAY_LEVEL = 2;
    private static final int VERSION_LEVEL = 3;
    private FileSystemRepository repository;
    private DateRange dateRange;
    private String reportId;
    private QueryResultList results;
    private DirectorySorter dirSorter;
    private TenantID tenantID;

    public ReportVersionsQuery(FileSystemArchive fileSystemArchive, TenantID t) {
        this.repository = fileSystemArchive.getRepository();
        this.tenantID = t;
    }

    @Override
    public List<IDataDescriptor> executeQuery(IQueryParameters parameters) throws RepositoryException {
        this.processParameters(parameters);
        File repositoryRootDirectory = new File(this.repository.getRepositoryLocation(this.tenantID));
        File reportDirectory = new File(repositoryRootDirectory, new ReportID(this.reportId).getFilePath());
        this.walkDirectory(reportDirectory, 0);
        return this.results;
    }

    private boolean walkDirectory(File directory, int depth) throws RepositoryException {
        File[] files = this.dirSorter.sortFiles(directory);
        boolean keepProcessing = true;
        if (files != null && files.length > 0) {
            for (int idx = 0; idx < files.length && keepProcessing; ++idx) {
                if (!files[idx].isDirectory()) continue;
                if (depth < 3 && this.isInDateRange(files[idx], depth)) {
                    keepProcessing = this.walkDirectory(files[idx], depth + 1);
                    continue;
                }
                if (depth != 3) continue;
                IDataDescriptor descriptor = this.createDataDescriptor(files[idx]);
                keepProcessing = this.results.add(descriptor);
            }
        }
        return keepProcessing;
    }

    private IDataDescriptor createDataDescriptor(File file) throws RepositoryException {
        FileSystemDataDescriptor descriptor = new FileSystemDataDescriptor();
        descriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("reportStoreID", (Object)this.reportId));
        String versionTimeStamp = FileNameBuilder.getTimeStampFromVersionDirectoryName(file.getName());
        String objectId = new VersionID(this.reportId, versionTimeStamp).toString();
        descriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("versionObjectID", (Object)objectId));
        descriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("repositoryObjectId", (Object)objectId));
        Calendar versionTime = this.getCalendarFromTimeStamp(versionTimeStamp);
        descriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("creationTime", (Object)versionTime));
        descriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("modificationTime", (Object)versionTime));
        descriptor.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("defaultDescription", (Object)versionTimeStamp));
        return descriptor;
    }

    private Calendar getCalendarFromTimeStamp(String timeStamp) {
        try {
            XMLGregorianCalendar calendar = XMLGregorianCalendarProvider.parse((String)timeStamp);
            return calendar.toGregorianCalendar();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid version directory's name", e);
        }
    }

    private boolean isInDateRange(File file, int depth) {
        boolean isInRange = false;
        switch (depth) {
            case 0: {
                isInRange = this.dateRange.isInRange(new DateHolder(Integer.valueOf(file.getName())));
                break;
            }
            case 1: {
                isInRange = this.dateRange.isInRange(new DateHolder(Integer.valueOf(file.getParentFile().getName()), Integer.valueOf(file.getName()) - 1));
                break;
            }
            case 2: {
                isInRange = this.dateRange.isInRange(new DateHolder(Integer.valueOf(file.getParentFile().getParentFile().getName()), Integer.valueOf(file.getParentFile().getName()) - 1, Integer.valueOf(file.getName())));
                break;
            }
        }
        return isInRange;
    }

    private void processParameters(IQueryParameters parameters) {
        Calendar startDate = (Calendar)this.getParameterValue(parameters, "afterCreationTime");
        Calendar endDate = (Calendar)this.getParameterValue(parameters, "beforeCreationTime");
        this.dateRange = new DateRange(startDate, endDate);
        this.reportId = (String)this.getParameterValue(parameters, "reportStoreID");
        int maxCount = (Integer)this.getParameterValue(parameters, "maxCount");
        int skipItems = (Integer)this.getParameterValue(parameters, "skipItems");
        this.results = new QueryResultList(maxCount, skipItems);
        String sortOrder = (String)this.getParameterValue(parameters, "sortingOrder");
        this.dirSorter = sortOrder != null && "ASC".equals(sortOrder) ? DirectorySorterFactory.getInstance().getAscendingSorter() : DirectorySorterFactory.getInstance().getDescendingSorter();
    }

    private Object getParameterValue(IQueryParameters parameters, String parameterName) {
        IQueryParameter parameter = parameters.getParameter(parameterName);
        if (parameter != null) {
            return parameter.getValue();
        }
        return null;
    }
}

