/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.fileSystemPlugin.query;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.fileSystemPlugin.metadata.DescriptorProperties;
import com.ibm.cognos.cm.fileSystemPlugin.query.ReportID;
import com.ibm.cognos.cm.repositoryplugincommon.XMLGregorianCalendarProvider;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.io.IOUtils;

public class VersionID
extends ReportID {
    private XMLGregorianCalendar timeStamp;
    private String dateString;

    public VersionID(DescriptorProperties props) throws RepositoryException {
        this(props.getReportStoreID(), props.getReportVersionTimeStamp());
    }

    public VersionID(String reportId, String versionTimeStamp) throws RepositoryException {
        this(new String[]{reportId, versionTimeStamp});
    }

    VersionID(String[] idTokens) throws RepositoryException {
        super(idTokens);
    }

    @Override
    protected void processIDTokens(String[] parts) throws RepositoryException {
        super.processIDTokens(parts);
        if (parts.length < 2) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError);
        }
        this.dateString = parts[1];
        this.timeStamp = XMLGregorianCalendarProvider.parse((String)this.dateString);
    }

    @Override
    protected void processFilePath(StringBuilder buffer) throws RepositoryException {
        super.processFilePath(buffer);
        buffer.append(IOUtils.DIR_SEPARATOR);
        buffer.append(this.timeStamp.getYear());
        buffer.append(IOUtils.DIR_SEPARATOR);
        buffer.append(String.format("%02d", this.timeStamp.getMonth()));
        buffer.append(IOUtils.DIR_SEPARATOR);
        buffer.append(String.format("%02d", this.timeStamp.getDay()));
        buffer.append(IOUtils.DIR_SEPARATOR);
        buffer.append(this.timeStamp.toXMLFormat().replace(":", ""));
    }

    @Override
    protected void buildID(StringBuilder builder) throws RepositoryException {
        super.buildID(builder);
        builder.append("_");
        builder.append(this.timeStamp.toXMLFormat());
    }

    public final XMLGregorianCalendar getTimeStamp() {
        return this.timeStamp;
    }

    public static VersionID valueOf(String id) throws RepositoryException {
        try {
            String[] idTokens = ReportID.tokenizeIdString(id);
            return new VersionID(idTokens);
        }
        catch (Exception e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
    }

    public String getDateString() {
        return this.dateString;
    }

    void setTimeStamp(XMLGregorianCalendar timeStamp) {
        this.timeStamp = timeStamp;
    }
}

