/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.repository.plugin.configuration.xml;

import com.cognos.cm.repository.plugin.configuration.IConfigurationCondition;
import com.cognos.cm.repository.plugin.configuration.IPluginConfigurationBuilder;
import com.cognos.cm.repository.plugin.configuration.IQueriesConfiguration;
import com.cognos.cm.repository.plugin.configuration.IQueryConfiguration;
import com.cognos.cm.repository.plugin.configuration.IRepositoryConnectionConfiguration;
import com.cognos.cm.repository.plugin.configuration.IRepositoryObjectType;
import com.cognos.cm.repository.plugin.configuration.IRepositoryQueryParameterConfiguration;
import com.cognos.cm.repository.plugin.configuration.IWriteConfiguration;
import com.cognos.cm.repository.plugin.configuration.RepositoryPropertyType;
import com.cognos.cm.repository.plugin.configuration.xml.AndConfigurationCondition;
import com.cognos.cm.repository.plugin.configuration.xml.ConnectionConfiguration;
import com.cognos.cm.repository.plugin.configuration.xml.MetadataExistsConfigurationCondition;
import com.cognos.cm.repository.plugin.configuration.xml.MetadataStringValueConfigurationCondition;
import com.cognos.cm.repository.plugin.configuration.xml.OrConfigurationCondition;
import com.cognos.cm.repository.plugin.configuration.xml.PropertyValueHandlerFactory;
import com.cognos.cm.repository.plugin.configuration.xml.QueriesConfiguration;
import com.cognos.cm.repository.plugin.configuration.xml.RepositoryObjectType;
import com.cognos.cm.repository.plugin.configuration.xml.RepositoryQueryConfiguration;
import com.cognos.cm.repository.plugin.configuration.xml.RepositoryQueryOptionalClause;
import com.cognos.cm.repository.plugin.configuration.xml.RepositoryQueryParameterConfiguration;
import com.cognos.cm.repository.plugin.configuration.xml.WriteConfiguration;
import com.cognos.cm.repositoryPluginAPI.IPropertyValueHandler;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cm.repositoryPluginFramework.RepositoryFrameworkConstants;
import com.cognos.cm.repositoryPluginFramework.RepositoryObjectProperty;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlPluginConfigurationBuilder
implements IPluginConfigurationBuilder {
    private static final String CURRENT_DIR_PATH = ".//";
    private static final String CONSUMER_REPOSITORY_SEPARATOR = "_";
    public static final String RESOURCE_REPOSITORIES_CONFIG = "config/";
    public static final String RESOURCE_REPOSITORIES_CONFIG_XML_EXTENTION = ".xml";
    private IPluginResourceLoader resourceLoader;
    private PropertyValueHandlerFactory handlerFactory;

    public XmlPluginConfigurationBuilder(IPluginResourceLoader resourceLoader) {
        this(resourceLoader, new PropertyValueHandlerFactory());
    }

    XmlPluginConfigurationBuilder(IPluginResourceLoader resourceLoader, PropertyValueHandlerFactory handlerFactory) {
        this.resourceLoader = resourceLoader;
        this.handlerFactory = handlerFactory;
    }

    @Override
    public IRepositoryConnectionConfiguration createConfiguration(String consumerName, String repositoryType) throws RepositoryException {
        WriteConfiguration writeConfiguration = this.createWriteConfiguration();
        QueriesConfiguration queryConfiguration = this.createQueryConfiguration();
        IRepositoryConnectionConfiguration configuration = this.createConnectionConfiguration(writeConfiguration, queryConfiguration);
        String resourceName = this.createConsumerRepositoryConfigurationName(consumerName, repositoryType);
        Document connectionConfigurationDocument = this.getPluginConfigurationDocument(resourceName);
        if (connectionConfigurationDocument == null) {
            this.throwConfigurationParsingException(resourceName);
        }
        Element rootNode = connectionConfigurationDocument.getRootElement();
        this.loadWriteConfiguration(writeConfiguration, resourceName, rootNode);
        this.loadQueriesConfiguration(queryConfiguration, resourceName, rootNode);
        return configuration;
    }

    private void loadQueriesConfiguration(QueriesConfiguration queryConfiguration, String resourceName, Element rootNode) throws RepositoryException {
        List nodes = XMLUtils.selectNodes((Element)rootNode, (String)".//queryConfiguration");
        if (nodes.size() > 1) {
            this.throwConfigurationParsingException(resourceName);
        }
        if (nodes.size() == 1) {
            Element queryConfigurationElement = (Element)nodes.get(0);
            this.loadQueries(queryConfiguration, resourceName, queryConfigurationElement);
            this.loadParameters(queryConfiguration, resourceName, queryConfigurationElement);
        }
    }

    private void loadWriteConfiguration(WriteConfiguration writeConfiguration, String resourceName, Element rootNode) throws RepositoryException {
        List nodes = XMLUtils.selectNodes((Element)rootNode, (String)".//writeConfiguration");
        if (nodes.size() > 1) {
            this.throwConfigurationParsingException(resourceName);
        }
        if (nodes.size() == 1) {
            Element writeConfigurationElement = (Element)nodes.get(0);
            this.loadObjectTypes(writeConfiguration, resourceName, writeConfigurationElement);
            this.loadCharacterMappings(writeConfiguration, resourceName, writeConfigurationElement);
        }
    }

    private void loadCharacterMappings(WriteConfiguration configuration, String resourceName, Element writeConfigurationNode) {
        Element characterMappingsElement = this.getOptionalChildElement(writeConfigurationNode, "characterMappings");
        if (characterMappingsElement == null) {
            return;
        }
        Map<String, String> characterMappings = this.buildCharacterMappings(resourceName, characterMappingsElement);
        this.validateMappings(characterMappings);
        if (!characterMappings.isEmpty()) {
            configuration.setCharacterMappings(characterMappings);
        }
    }

    private void validateMappings(Map<String, String> characterMappings) {
        for (String invalidString : characterMappings.keySet()) {
            for (String replacementString : characterMappings.values()) {
                if (replacementString == null || !replacementString.contains(invalidString)) continue;
                throw new IllegalStateException("\"replaceWith=" + replacementString + "\" cannot contain invalid character string \"" + invalidString + "\"");
            }
        }
    }

    private Map<String, String> buildCharacterMappings(String resourceName, Element characterMappingsElement) {
        HashMap<String, String> characterMappings = new HashMap<String, String>();
        List<Element> characterMappingNodes = this.selectCharacterMappingNodes(characterMappingsElement);
        for (Element characterElement : characterMappingNodes) {
            String invalidCharacterStr = this.getRequiredAttribute(characterElement, "invalidCharacter", resourceName);
            String replacementCharacterStr = this.getOptionalAttribute(characterElement, "replaceWith");
            if (!StringUtils.isNotEmpty((String)invalidCharacterStr)) continue;
            characterMappings.put(invalidCharacterStr, replacementCharacterStr);
        }
        return characterMappings;
    }

    private void loadQueries(QueriesConfiguration queriesConfiguration, String resourceName, Element queryConfigurationElement) {
        List queryElements = XMLUtils.selectNodes((Element)queryConfigurationElement, (String)".//query");
        for (Element queryElement : queryElements) {
            IQueryConfiguration queryConfiguration = this.loadQueryConfiguration(queryElement, resourceName);
            queriesConfiguration.addQuery(queryConfiguration);
        }
    }

    private IQueryConfiguration loadQueryConfiguration(Element queryElement, String resourceName) {
        RepositoryQueryConfiguration query = this.createQueryConfiguration(queryElement, resourceName);
        this.loadQueryText(queryElement, query);
        this.loadOptionalClauses(queryElement, query, resourceName);
        this.loadQueryParameters(query, queryElement, resourceName);
        this.loadQueryProperties(query, queryElement, resourceName);
        this.loadQueryPreRequisiteQueries(query, queryElement);
        this.loadQuerySubsequentQueries(query, queryElement);
        return query;
    }

    private RepositoryQueryConfiguration createQueryConfiguration(Element queryElement, String resourceName) {
        String queryName = this.getRequiredAttribute(queryElement, "name", resourceName);
        RepositoryQueryConfiguration query = new RepositoryQueryConfiguration(queryName);
        String conditionParameter = this.getOptionalAttribute(queryElement, "conditionParameter");
        String resultPorcessorName = this.getOptionalAttribute(queryElement, "resultProcessor");
        if (StringUtils.isNotEmpty((String)resultPorcessorName)) {
            query.setResultProcessorName(resultPorcessorName);
        }
        if (StringUtils.isNotEmpty((String)conditionParameter)) {
            query.setConditionParameterName(conditionParameter);
        }
        return query;
    }

    private void loadOptionalClauses(Element queryElement, RepositoryQueryConfiguration query, String resourceName) {
        Element optionalClausesElement = this.getOptionalChildElement(queryElement, "optionalClauses");
        if (optionalClausesElement != null) {
            List clauseElements = XMLUtils.selectNodes((Element)optionalClausesElement, (String)".//clause");
            for (Element clauseElement : clauseElements) {
                String name = this.getRequiredAttribute(clauseElement, "name", resourceName);
                Element clauseTextElement = this.getOptionalChildElement(clauseElement, "clauseText");
                String text = clauseTextElement.getText();
                RepositoryQueryOptionalClause clause = new RepositoryQueryOptionalClause(name);
                this.loadClauseParameters(clause, clauseElement, resourceName);
                clause.setClauseText(text);
                query.addOptionalClause(name, clause);
            }
        }
    }

    private void loadClauseParameters(RepositoryQueryOptionalClause clause, Element clauseElement, String resourceName) {
        List<Element> parameterElements = this.selectParameterNodes(clauseElement);
        for (Element parameterElement : parameterElements) {
            IRepositoryQueryParameterConfiguration parameter = this.createQueryParameterConfiguration(parameterElement, resourceName);
            clause.addParameter(parameter);
        }
    }

    private void loadQueryText(Element queryElement, RepositoryQueryConfiguration query) {
        Element queryTextElement = this.getOptionalChildElement(queryElement, "queryText");
        if (queryTextElement != null) {
            query.setQueryText(queryTextElement.getText());
        }
    }

    private void loadQueryProperties(RepositoryQueryConfiguration query, Element queryElement, String resourceName) {
        List<Element> propertyElements = this.selectPropertyNodes(queryElement);
        for (Element propertyElement : propertyElements) {
            RepositoryObjectProperty targetProperty = this.createRepositoryQueryObjectProperty(propertyElement, resourceName, "queryConfigurationType");
            query.addProperty(targetProperty);
            query.addRepositoryProperty(targetProperty);
        }
    }

    private void loadQueryParameters(RepositoryQueryConfiguration query, Element queryElement, String resourceName) {
        List<Element> parameterElements = this.selectParameterNodes(queryElement);
        for (Element parameterElement : parameterElements) {
            IRepositoryQueryParameterConfiguration parameter = this.createQueryParameterConfiguration(parameterElement, resourceName);
            query.addParameter(parameter);
        }
    }

    private void loadQueryPreRequisiteQueries(RepositoryQueryConfiguration query, Element queryElement) {
        String queryPreRequisites = this.getOptionalAttribute(queryElement, "prerequisiteQueries");
        if (StringUtils.isNotEmpty((String)queryPreRequisites)) {
            List<String> queryNamesList = this.splitAttributeValue(queryPreRequisites);
            query.addPrerequisiteQueryNames(queryNamesList);
        }
    }

    private void loadQuerySubsequentQueries(RepositoryQueryConfiguration query, Element queryElement) {
        String subsequentQueries = this.getOptionalAttribute(queryElement, "subsequentQueries");
        if (StringUtils.isNotEmpty((String)subsequentQueries)) {
            List<String> queryNamesList = this.splitAttributeValue(subsequentQueries);
            query.addSubsequentQueryNames(queryNamesList);
        }
    }

    private List<String> splitAttributeValue(String attibuteValue) {
        return Arrays.asList(StringUtils.split((String)attibuteValue, (String)", "));
    }

    private void loadObjectTypeProperties(Element objectTypeElement, IRepositoryObjectType objectType, String resourceName) {
        List<Element> propertyElements = this.selectPropertyNodes(objectTypeElement);
        for (Element propertyElement : propertyElements) {
            Element enclosedElement;
            RepositoryObjectProperty targetProperty = this.createRepositoryObjectProperty(propertyElement, resourceName, objectType.getName());
            objectType.addProperty(targetProperty);
            Element associatedDocumentElement = this.getOptionalChildElement(propertyElement, "associatedObjectTypes");
            if (associatedDocumentElement != null) {
                IRepositoryObjectType associatedProperyObjectType = this.createAssociatedPropertyObjectType(associatedDocumentElement, resourceName);
                targetProperty.setAssociatedPropertyObjectType(associatedProperyObjectType);
            }
            if ((enclosedElement = this.getOptionalChildElement(propertyElement, "objectType")) == null) continue;
            IRepositoryObjectType enclosedObjectType = this.loadObjectType(enclosedElement, resourceName);
            this.loadChildObjectTypes(enclosedElement, enclosedObjectType, resourceName);
            targetProperty.setEnclosedObjectType(enclosedObjectType);
        }
    }

    private IRepositoryObjectType createAssociatedPropertyObjectType(Element associatedDocumentElement, String resourceName) {
        Element objectTypeElement = this.getOptionalChildElement(associatedDocumentElement, "objectType");
        if (objectTypeElement == null) {
            return null;
        }
        IRepositoryObjectType objectType = this.loadObjectType(objectTypeElement, resourceName);
        this.loadChildObjectTypes(objectTypeElement, objectType, resourceName);
        return objectType;
    }

    private void loadObjectTypeCondition(Element objectTypeElement, RepositoryObjectType objectType, String resourceName) {
        Element rootConditionElement = this.selectConditionNode(objectTypeElement);
        if (rootConditionElement == null) {
            return;
        }
        List<IConfigurationCondition> conditions = this.createConditions(rootConditionElement, resourceName);
        if (conditions.size() != 1) {
            throw new IllegalStateException("expected one root condition but found " + conditions.size() + " in " + resourceName);
        }
        objectType.setCondition(conditions.get(0));
    }

    private List<IConfigurationCondition> createConditions(Element rootConditionElement, String resourceName) {
        ArrayList<IConfigurationCondition> conditions = new ArrayList<IConfigurationCondition>();
        List conditionElements = rootConditionElement.elements();
        for (Element conditionElement : conditionElements) {
            IConfigurationCondition condition = null;
            condition = this.createCondition(resourceName, conditionElement, condition);
            conditions.add(condition);
        }
        return conditions;
    }

    private IConfigurationCondition createCondition(String resourceName, Element conditionElement, IConfigurationCondition condition) {
        String conditionName = conditionElement.getName();
        if (conditionName.equals(RepositoryFrameworkConstants.CONDITION_AND)) {
            List<IConfigurationCondition> childConditions = this.createConditions(conditionElement, resourceName);
            this.verifyChildConditions(resourceName, childConditions);
            condition = new AndConfigurationCondition(childConditions);
        } else if (conditionName.equals(RepositoryFrameworkConstants.CONDITION_OR)) {
            List<IConfigurationCondition> childConditions = this.createConditions(conditionElement, resourceName);
            this.verifyChildConditions(resourceName, childConditions);
            condition = new OrConfigurationCondition(childConditions);
        } else if (conditionName.equals(RepositoryFrameworkConstants.CONDITION_METADATA_EXISTS)) {
            String metadataPropertyName = this.getRequiredAttribute(conditionElement, "metadataPropertyName", resourceName);
            condition = new MetadataExistsConfigurationCondition(metadataPropertyName);
        } else if (conditionName.equals(RepositoryFrameworkConstants.CONDITION_METADATA_VALUE)) {
            String metadataPropertyName = this.getRequiredAttribute(conditionElement, "metadataPropertyName", resourceName);
            String metadataPropertyValue = this.getRequiredAttribute(conditionElement, "value", resourceName);
            condition = new MetadataStringValueConfigurationCondition(metadataPropertyName, metadataPropertyValue);
        } else {
            throw new IllegalStateException("unsupported condition " + conditionName + " in " + resourceName);
        }
        return condition;
    }

    private void verifyChildConditions(String resourceName, List<IConfigurationCondition> childConditions) {
        if (childConditions.size() == 0) {
            throw new IllegalStateException("missing child conditions in " + resourceName);
        }
    }

    private List<Element> selectPropertyNodes(Element objectTypeElement) {
        List propertyElements = XMLUtils.selectNodes((Element)objectTypeElement, (String)"./properties/property");
        return propertyElements;
    }

    private Element selectConditionNode(Element objectTypeElement) {
        List conditionElements = XMLUtils.selectNodes((Element)objectTypeElement, (String)"./condition");
        return this.getSingleElementFromList(objectTypeElement.getName(), conditionElements);
    }

    private Element getSingleElementFromList(String parentElementName, List<Element> elements) {
        if (elements.size() > 1) {
            throw new IllegalStateException("unexpected number of conditions in " + parentElementName);
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        return null;
    }

    private List<Element> selectParameterNodes(Element objectTypeElement) {
        List propertyElements = XMLUtils.selectNodes((Element)objectTypeElement, (String)"./parameters/parameter");
        return propertyElements;
    }

    private List<Element> selectCharacterMappingNodes(Element characterMappingsElement) {
        List propertyElements = XMLUtils.selectNodes((Element)characterMappingsElement, (String)"./characterMapping");
        return propertyElements;
    }

    private void loadObjectTypes(WriteConfiguration configuration, String resourceName, Element writeConfigurationNode) {
        Element objectTypesElement = this.getOptionalChildElement(writeConfigurationNode, "objectTypes");
        if (objectTypesElement == null) {
            return;
        }
        Element objectTypeElement = this.getOptionalChildElement(objectTypesElement, "objectType");
        if (objectTypeElement == null) {
            return;
        }
        IRepositoryObjectType objectType = this.loadObjectType(objectTypeElement, resourceName);
        configuration.setRootObjectType(objectType);
        this.loadChildObjectTypes(objectTypeElement, objectType, resourceName);
    }

    private IRepositoryObjectType loadObjectType(Element objectTypeElement, String resourceName) {
        String objectTypeName = this.getRequiredAttribute(objectTypeElement, "name", resourceName);
        RepositoryObjectType objectType = new RepositoryObjectType(objectTypeName);
        this.loadObjectTypeAttributes(objectTypeElement, objectType);
        this.loadObjectTypeProperties(objectTypeElement, objectType, resourceName);
        this.loadObjectTypeCondition(objectTypeElement, objectType, resourceName);
        return objectType;
    }

    private void loadObjectTypeAttributes(Element objectTypeElement, RepositoryObjectType objectType) {
        String locationDescribedBy;
        String isFolderAttribute = this.getOptionalAttribute(objectTypeElement, "isFolder");
        if (isFolderAttribute != null) {
            boolean isFolder = Boolean.valueOf(isFolderAttribute);
            objectType.setIsFolder(isFolder);
        }
        if ((locationDescribedBy = this.getOptionalAttribute(objectTypeElement, "locationDescribedBy")) != null) {
            objectType.setLocationDescriptionPropName(locationDescribedBy);
        }
    }

    private void loadChildObjectTypes(Element objectTypeElement, IRepositoryObjectType objectType, String resourceName) {
        Element objectTypesElement = this.getOptionalChildElement(objectTypeElement, "objectTypes");
        if (objectTypesElement != null) {
            List childElements = objectTypesElement.elements("objectType");
            for (Element childObjectTypeElement : childElements) {
                IRepositoryObjectType childObjectType = this.loadObjectType(childObjectTypeElement, resourceName);
                objectType.addChild(childObjectType);
                this.loadChildObjectTypes(childObjectTypeElement, childObjectType, resourceName);
            }
        }
    }

    private RepositoryObjectProperty createRepositoryObjectProperty(Element propertyElement, String resourceName, String repositoryObjectTypeName) {
        String repositoryPropertyName = this.getRequiredAttribute(propertyElement, "repositoryName", resourceName);
        String repositoryPropertyType = this.getRequiredAttribute(propertyElement, "repositoryType", resourceName);
        String metadataPropertyName = this.getOptionalAttribute(propertyElement, "metadataPropertyName");
        String propertyValueHandlerName = this.getOptionalAttribute(propertyElement, "valueHandler");
        String propertyValueHandlerArgument = this.getOptionalAttribute(propertyElement, "valueHandlerArgument");
        IPropertyValueHandler valueHandler = this.handlerFactory.createValueHandler(propertyValueHandlerName, metadataPropertyName, propertyValueHandlerArgument);
        String propertyValueHandlerForConflictResolutionName = this.getOptionalAttribute(propertyElement, "valueHandlerForConflictResolution");
        String propertyValueHandlerForConflictResolutionArgument = this.getOptionalAttribute(propertyElement, "valueHandlerForConflictResolutionArgument");
        IPropertyValueHandler valueHandlerForConflictResolution = this.handlerFactory.createValueHandler(propertyValueHandlerForConflictResolutionName, metadataPropertyName, propertyValueHandlerForConflictResolutionArgument);
        RepositoryObjectProperty targetProperty = new RepositoryObjectProperty(repositoryObjectTypeName, repositoryPropertyName, RepositoryPropertyType.valueOf(repositoryPropertyType), valueHandler, valueHandlerForConflictResolution, metadataPropertyName);
        return targetProperty;
    }

    private RepositoryObjectProperty createRepositoryQueryObjectProperty(Element propertyElement, String resourceName, String repositoryObjectTypeName) {
        String repositoryPropertyName = this.getOptionalAttribute(propertyElement, "repositoryName");
        String repositoryPropertyType = this.getOptionalAttribute(propertyElement, "repositoryType");
        String metadataPropertyName = this.getRequiredAttribute(propertyElement, "metadataPropertyName", resourceName);
        String propertyValueHandlerName = this.getOptionalAttribute(propertyElement, "valueHandler");
        String propertyValueHandlerArgument = this.getOptionalAttribute(propertyElement, "valueHandlerArgument");
        IPropertyValueHandler valueHandler = this.handlerFactory.createValueHandler(propertyValueHandlerName, metadataPropertyName, propertyValueHandlerArgument);
        String propertyValueHandlerForConflictResolutionName = this.getOptionalAttribute(propertyElement, "valueHandlerForConflictResolution");
        String propertyValueHandlerForConflictResolutionArgument = this.getOptionalAttribute(propertyElement, "valueHandlerForConflictResolutionArgument");
        IPropertyValueHandler valueHandlerForConflictResolution = this.handlerFactory.createValueHandler(propertyValueHandlerForConflictResolutionName, metadataPropertyName, propertyValueHandlerForConflictResolutionArgument);
        RepositoryObjectProperty targetProperty = new RepositoryObjectProperty(repositoryObjectTypeName, repositoryPropertyName, RepositoryPropertyType.valueOf(repositoryPropertyType), valueHandler, valueHandlerForConflictResolution, metadataPropertyName);
        return targetProperty;
    }

    private IRepositoryQueryParameterConfiguration createQueryParameterConfiguration(Element parameterElement, String resourceName) {
        String parameterName = this.getRequiredAttribute(parameterElement, "name", resourceName);
        String repositoryPropertyType = this.getRequiredAttribute(parameterElement, "repositoryType", resourceName);
        RepositoryQueryParameterConfiguration parameter = new RepositoryQueryParameterConfiguration(parameterName, RepositoryPropertyType.valueOf(repositoryPropertyType));
        return parameter;
    }

    private String createConsumerRepositoryConfigurationName(String consumerName, String repositoryType) throws RepositoryException {
        if (consumerName == null && repositoryType == null) {
            this.throwConfigurationParsingException();
        }
        if (consumerName == null) {
            return repositoryType;
        }
        if (repositoryType == null) {
            return consumerName;
        }
        return consumerName + CONSUMER_REPOSITORY_SEPARATOR + repositoryType;
    }

    @Override
    public Document getPluginConfigurationDocument(String configurationResourceShortName) throws RepositoryException {
        String pluginConfigurationResourceName = RESOURCE_REPOSITORIES_CONFIG + configurationResourceShortName + RESOURCE_REPOSITORIES_CONFIG_XML_EXTENTION;
        InputStream pluginConfigurationFileInputStream = this.getPluginConfigurationFileInputStream(pluginConfigurationResourceName, this.resourceLoader);
        if (pluginConfigurationFileInputStream == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        try {
            return reader.read(pluginConfigurationFileInputStream);
        }
        catch (Exception ex) {
            Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.errorReadingConfig).param("Name", pluginConfigurationResourceName);
            throw new RepositoryException(msg, (Throwable)ex);
        }
    }

    InputStream getPluginConfigurationFileInputStream(String pluginConfigurationResourceName, IPluginResourceLoader resourceLoader) {
        InputStream pluginConfigurationFileInputStream = resourceLoader.getResourceInputStream(pluginConfigurationResourceName);
        return pluginConfigurationFileInputStream;
    }

    IRepositoryConnectionConfiguration createConnectionConfiguration(IWriteConfiguration writeConfiguration, IQueriesConfiguration queryConfiguration) {
        return new ConnectionConfiguration(writeConfiguration, queryConfiguration);
    }

    WriteConfiguration createWriteConfiguration() {
        return new WriteConfiguration();
    }

    QueriesConfiguration createQueryConfiguration() {
        return new QueriesConfiguration();
    }

    private String getRequiredAttribute(Element rootNode, String attributeName, String resourceName) {
        String name = rootNode.attributeValue(attributeName);
        if (name == null) {
            throw new IllegalStateException("missing required attribute " + attributeName + " in the element " + rootNode.getName() + " in the configuration file " + resourceName);
        }
        return name;
    }

    private String getOptionalAttribute(Element rootNode, String attributeName) {
        return rootNode.attributeValue(attributeName);
    }

    private Element getOptionalChildElement(Element rootNode, String elementName) {
        return rootNode.element(elementName);
    }

    private void throwConfigurationParsingException(String resourceName) throws RepositoryException {
        Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.errorReadingConfig).param("Name", resourceName);
        throw new RepositoryException(msg);
    }

    private void throwConfigurationParsingException(String resourceName, Exception e) throws RepositoryException {
        Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.errorReadingConfig).param("Name", resourceName);
        throw new RepositoryException(msg, (Throwable)e);
    }

    private void throwConfigurationParsingException() throws RepositoryException {
        throw new RepositoryException(RepositoryPluginErrors.REP_API.errorReadingConfig);
    }

    private void loadParameters(QueriesConfiguration queriesConfiguration, String resourceName, Element queryConfigurationElement) throws RepositoryException {
        List parameterElements = XMLUtils.selectNodes((Element)queryConfigurationElement, (String)"./parameters/parameter");
        for (Element parameterElement : parameterElements) {
            String parameterName = this.getRequiredAttribute(parameterElement, "name", resourceName);
            String parameterType = this.getRequiredAttribute(parameterElement, "type", resourceName);
            String parameterValue = this.getRequiredAttribute(parameterElement, "value", resourceName);
            if (!StringUtils.isNotEmpty((String)parameterName) || !StringUtils.isNotEmpty((String)parameterType) || !StringUtils.isNotEmpty((String)parameterValue)) continue;
            Object value = this.getParameterValue(parameterType, parameterValue, resourceName);
            queriesConfiguration.addParameter(parameterName, value);
        }
    }

    private Object getParameterValue(String parameterType, String parameterValue, String resourceName) throws RepositoryException {
        try {
            if ("Integer".equalsIgnoreCase(parameterType)) {
                return Integer.valueOf(parameterValue);
            }
            if ("Boolean".equalsIgnoreCase(parameterType)) {
                return Boolean.valueOf(parameterValue);
            }
            if ("String".equalsIgnoreCase(parameterType)) {
                return parameterValue;
            }
            this.throwConfigurationParsingException(resourceName);
        }
        catch (NumberFormatException e) {
            this.throwConfigurationParsingException(resourceName, e);
        }
        return null;
    }
}

