/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.repositoryPluginFramework;

import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IPropertyValueHandler;
import java.util.Scanner;

public class PropertyValueConcatenateHandler
implements IPropertyValueHandler {
    private static final char VALUE_DELIMITER = '-';
    private String metadataPropertyName;
    private String argument;

    public PropertyValueConcatenateHandler(String metadataPropertyName, String argument) {
        this.metadataPropertyName = metadataPropertyName;
        this.argument = argument;
    }

    @Override
    public Object getValue(IDataDescriptor metadata) {
        String value = this.getPropertyValue(this.metadataPropertyName, metadata);
        if (value == null) {
            return null;
        }
        if (this.argument == null) {
            return value;
        }
        Scanner argumentToker = new Scanner(this.argument).useDelimiter(",");
        StringBuffer buffer = new StringBuffer();
        buffer.append(value);
        while (argumentToker.hasNext()) {
            String nextPropertyName = argumentToker.next();
            String nextValue = this.getPropertyValue(nextPropertyName, metadata);
            if (nextValue == null) continue;
            buffer.append('-');
            buffer.append(nextValue);
        }
        return buffer.toString();
    }

    private String getPropertyValue(String propertyName, IDataDescriptor metadata) {
        IDataDescriptorProperty property = metadata.getProperty(propertyName);
        if (property == null) {
            return null;
        }
        String value = property.getStringValue();
        return value;
    }

    @Override
    public void setValue(IDataDescriptor metadata, Object value) {
        throw new IllegalStateException("unsupported method");
    }
}

