/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.repositoryPluginFramework;

import com.cognos.cm.repository.plugin.configuration.ConfigurationBuilderFactory;
import com.cognos.cm.repository.plugin.configuration.IPluginConfigurationBuilder;
import com.cognos.cm.repository.plugin.configuration.IRepositoryConnectionConfiguration;
import com.cognos.cm.repositoryPluginAPI.IRepositoryPluginContainer;
import com.cognos.cm.repositoryPluginAPI.IRepositoryUserAgentFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginAPI.RepositoryPlugin;
import com.cognos.cm.repositoryPluginFramework.ConfigurationWithCounter;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cm.repositoryPluginFramework.IRepositoryConnectionString;
import com.cognos.cm.repositoryPluginFramework.IRepositoryPluginManager;
import com.cognos.cm.repositoryPluginFramework.IRepositoryServiceHelper;
import com.cognos.cm.repositoryPluginFramework.RepositoryConnectionWrapper;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginConnectionParameters;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginContainer;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginLoggingLevel;
import com.cognos.cm.repositoryPluginFramework.RepositoryServiceHelper;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Document;

public class RepositoryPluginManager
implements IRepositoryPluginManager {
    private static final String PROVIDER = "PROVIDER";
    private static final String CMCM_ID = "CMCM";
    private static final String REPSCM_ID = "REPSCM";
    private static IRepositoryPluginManager manager;
    private static IRepositoryServiceHelper repositoryServiceHelper;
    private static final int NUMBER_OF_REQUIRED_TOKENS_IN_URL = 3;
    private static final int PLUGIN_NAME_TOKEN_INDEX = 1;
    private static final int REPOSITORY_URL_TOKEN_INDEX = 2;
    private static final String PLUGIN_CONNECTION_URL_DELIMITER = "\\:";
    private static final String PLUGIN_CONNECTION_PARAMETERS_DELIMITER = "\\;";
    private static final String PLUGIN_CONNECTION_PARAMETER_NAME_DELIMITER = "=";
    private final Map<String, RepositoryPlugin> plugins = new HashMap<String, RepositoryPlugin>();
    private final Map<String, ConfigurationWithCounter> configurations = new HashMap<String, ConfigurationWithCounter>();

    protected RepositoryPluginManager() {
    }

    public static IRepositoryPluginManager getManager() {
        return manager;
    }

    public static IRepositoryServiceHelper getRepositoryServiceHelper() {
        return repositoryServiceHelper;
    }

    @Override
    public RepositoryConnection getConnection(String url, Properties properties, IPluginResourceLoader resourceLoader) throws RepositoryException {
        RepositoryPluginConnectionParameters connectionParameters = this.parsePluginUrl(url);
        return this.getConnection(properties, resourceLoader, connectionParameters, null);
    }

    @Override
    public RepositoryConnection getConnection(IRepositoryConnectionString connectionString, Properties properties, IPluginResourceLoader resourceLoader) throws RepositoryException {
        RepositoryPluginConnectionParameters connectionParameters = this.parseRepositoryConnectionString(connectionString);
        return this.getConnection(properties, resourceLoader, connectionParameters, null);
    }

    @Override
    public RepositoryConnection getConnection(IRepositoryUserAgentFactory userAgentFactory, IRepositoryConnectionString connectionString, Properties properties, IPluginResourceLoader resourceLoader) throws RepositoryException {
        RepositoryPluginConnectionParameters connectionParameters = this.parseRepositoryConnectionString(connectionString);
        return this.getConnection(properties, resourceLoader, connectionParameters, userAgentFactory);
    }

    private RepositoryConnection getConnection(Properties properties, IPluginResourceLoader resourceLoader, RepositoryPluginConnectionParameters connectionParameters, IRepositoryUserAgentFactory userAgentFactory) throws RepositoryException {
        String pluginName = connectionParameters.getPluginName();
        RepositoryPlugin plugin = this.getPlugin(pluginName, resourceLoader);
        Properties pluginProperties = this.combineProperties(properties, connectionParameters.getPluginProperties());
        String consumerName = pluginProperties.getProperty("CONSUMER_NAME");
        String repositoryType = pluginProperties.getProperty("REPOSITORY_TYPE");
        String consumerRepositoryPair = consumerName + repositoryType;
        IRepositoryPluginContainer container = null;
        if (!REPSCM_ID.equals(consumerRepositoryPair) && !CMCM_ID.equals(consumerRepositoryPair)) {
            ConfigurationWithCounter counter = this.configurations.get(consumerRepositoryPair);
            if (this.hasToReloadConfiguration(properties, counter)) {
                this.configurations.remove(consumerRepositoryPair);
            }
            counter = this.getConfigurationWithCounter(consumerName, repositoryType, consumerRepositoryPair, resourceLoader);
            counter.increaseCounter();
            container = this.createPluginContainer(pluginProperties, resourceLoader);
        }
        RepositoryConnection connection = this.getPluginConnection(connectionParameters, plugin, pluginProperties, container, userAgentFactory);
        RepositoryConnectionWrapper wrapper = new RepositoryConnectionWrapper(this, connection, consumerRepositoryPair);
        return wrapper;
    }

    private RepositoryConnection getPluginConnection(RepositoryPluginConnectionParameters connectionParameters, RepositoryPlugin plugin, Properties pluginProperties, IRepositoryPluginContainer container, IRepositoryUserAgentFactory userAgentFactory) throws RepositoryException {
        RepositoryConnection connection = userAgentFactory == null ? plugin.getConnection(connectionParameters.getUrl(), container, pluginProperties) : plugin.getConnection(userAgentFactory, connectionParameters.getUrl(), container, pluginProperties);
        return connection;
    }

    private boolean hasToReloadConfiguration(Properties properties, ConfigurationWithCounter counter) {
        return properties.getProperty("reload") != null && counter != null && counter.getCount() == 0;
    }

    private RepositoryPluginConnectionParameters parseRepositoryConnectionString(IRepositoryConnectionString connectionString) {
        String pluginName = connectionString.getMandatoryParameter("DRIVER_NAME");
        String repositoryUrl = connectionString.getMandatoryParameter("URL");
        String repositoryType = connectionString.getRepositoryType();
        Properties optionalConnectionProperties = new Properties();
        if (repositoryType != null) {
            String provider = connectionString.getOptionalParameter(PROVIDER);
            if (provider != null) {
                optionalConnectionProperties.put("REPOSITORY_TYPE", provider.toUpperCase());
            } else {
                optionalConnectionProperties.put("REPOSITORY_TYPE", repositoryType);
            }
        }
        Map<String, String> optionalParameters = connectionString.getOptionalParameters();
        for (String parameterName : optionalParameters.keySet()) {
            optionalConnectionProperties.put(parameterName, optionalParameters.get(parameterName));
        }
        return new RepositoryPluginConnectionParameters(pluginName, repositoryUrl, optionalConnectionProperties);
    }

    public static void reset() {
        manager = new RepositoryPluginManager();
        repositoryServiceHelper = new RepositoryServiceHelper();
    }

    private RepositoryPlugin getPlugin(String pluginName, IPluginResourceLoader resourceLoader) throws RepositoryException {
        RepositoryPlugin plugin = this.plugins.get(pluginName);
        if (plugin != null) {
            return plugin;
        }
        plugin = this.loadPlugin(pluginName);
        this.initializePlugin(pluginName, plugin, resourceLoader);
        this.plugins.put(pluginName, plugin);
        return plugin;
    }

    private void initializePlugin(String pluginName, RepositoryPlugin plugin, IPluginResourceLoader resourceLoader) throws RepositoryException {
        IPluginConfigurationBuilder builder = this.createConfigurationBuilder(resourceLoader);
        Document configurationDocument = builder.getPluginConfigurationDocument(this.getPluginShortName(pluginName));
        plugin.initialize(configurationDocument);
    }

    private String getPluginShortName(String pluginName) {
        int lastDotIndex = pluginName.lastIndexOf(46);
        String pluginShortName = lastDotIndex >= 0 && lastDotIndex + 1 < pluginName.length() ? pluginName.substring(lastDotIndex + 1) : pluginName;
        return pluginShortName;
    }

    private Properties combineProperties(Properties externalProperties, Properties pluginProperties) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)externalProperties);
        properties.putAll((Map<?, ?>)pluginProperties);
        return properties;
    }

    protected RepositoryPlugin loadPlugin(String pluginName) throws RepositoryException {
        String classname = this.getPluginClassName(pluginName);
        try {
            Class<?> pluginClass = Class.forName(classname);
            return (RepositoryPlugin)pluginClass.newInstance();
        }
        catch (Exception ex) {
            Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.cannotLoadRepositoryPlugin).param("Name", pluginName);
            throw new RepositoryException(msg, (Throwable)ex);
        }
    }

    private String getPluginClassName(String pluginName) {
        return pluginName;
    }

    private RepositoryPluginConnectionParameters parsePluginUrl(String url) throws RepositoryException {
        String[] tokens = url.split(PLUGIN_CONNECTION_URL_DELIMITER, 3);
        if (tokens.length < 3) {
            Message msg = new Message((Resource.Id)RepositoryPluginErrors.REP_API.cannotParseConnectionURL);
            throw new RepositoryException(msg);
        }
        String pluginName = tokens[1];
        String repositoryUrlAndParameters = tokens[2];
        String[] repositoryUrlTokens = repositoryUrlAndParameters.split(PLUGIN_CONNECTION_PARAMETERS_DELIMITER);
        String repositoryUrl = repositoryUrlTokens[0];
        Properties optionalConnectionProperties = new Properties();
        for (int i = 1; i < repositoryUrlTokens.length; ++i) {
            optionalConnectionProperties.putAll((Map<?, ?>)this.parseOptionalConnectionProperties(repositoryUrlTokens[i]));
        }
        return new RepositoryPluginConnectionParameters(pluginName, repositoryUrl, optionalConnectionProperties);
    }

    private Properties parseOptionalConnectionProperties(String parametersString) {
        Properties properties = new Properties();
        String[] tokens = parametersString.split(PLUGIN_CONNECTION_PARAMETERS_DELIMITER);
        for (int i = 0; i < tokens.length; ++i) {
            String parameter = tokens[i];
            String[] parameterTokens = parameter.split(PLUGIN_CONNECTION_PARAMETER_NAME_DELIMITER, 2);
            String parameterName = parameterTokens[0];
            String parameterValue = parameterTokens.length > 1 ? parameterTokens[1] : "";
            properties.setProperty(parameterName, parameterValue);
        }
        return properties;
    }

    private IRepositoryPluginContainer createPluginContainer(Properties pluginProperties, IPluginResourceLoader resourceLoader) throws RepositoryException {
        String consumerName = pluginProperties.getProperty("CONSUMER_NAME");
        String repositoryType = pluginProperties.getProperty("REPOSITORY_TYPE");
        String consumerRepositoryPair = consumerName + repositoryType;
        IRepositoryConnectionConfiguration configuration = null;
        ConfigurationWithCounter counter = this.getConfigurationWithCounter(consumerName, repositoryType, consumerRepositoryPair, resourceLoader);
        configuration = counter.getConfiguration();
        return this.createPluginContainer(configuration);
    }

    protected IRepositoryPluginContainer createPluginContainer(IRepositoryConnectionConfiguration connectionConfiguration) {
        return new RepositoryPluginContainer(connectionConfiguration);
    }

    protected IRepositoryConnectionConfiguration createPluginConfiguration(String consumerName, String repositoryType, IPluginResourceLoader resourceLoader) throws RepositoryException {
        IPluginConfigurationBuilder configurationBuilder = this.createConfigurationBuilder(resourceLoader);
        return configurationBuilder.createConfiguration(consumerName, repositoryType);
    }

    protected IPluginConfigurationBuilder createConfigurationBuilder(IPluginResourceLoader resourceLoader) {
        return ConfigurationBuilderFactory.getInstance().build(resourceLoader);
    }

    @Override
    @Deprecated
    public void setLoggingLevel(String consumerName, RepositoryPluginLoggingLevel pluginLoggingLevel, File logDir) throws SecurityException, IOException {
    }

    @Override
    public void terminate() {
        for (RepositoryPlugin plugin : this.plugins.values()) {
            plugin.terminate();
        }
        this.configurations.clear();
    }

    public void closeConnection(RepositoryConnectionWrapper connection) {
        String key = connection.getLabel();
        if (key != null) {
            this.closeThisConnection(key);
        }
    }

    void addPlugins(Map<String, RepositoryPlugin> plugins) {
        this.plugins.putAll(plugins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeThisConnection(String key) {
        Map<String, ConfigurationWithCounter> map = this.configurations;
        synchronized (map) {
            ConfigurationWithCounter counter = this.configurations.get(key);
            if (counter == null || counter.getCount() <= 0) {
                throw new IllegalStateException("Attempt to close an already closed conection for " + key);
            }
            counter.decreaseCounter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationWithCounter getConfigurationWithCounter(String consumerName, String repositoryType, String consumerRepositoryPair, IPluginResourceLoader resourceLoader) throws RepositoryException {
        ConfigurationWithCounter counter = null;
        Map<String, ConfigurationWithCounter> map = this.configurations;
        synchronized (map) {
            counter = this.configurations.get(consumerRepositoryPair);
            if (counter == null) {
                IRepositoryConnectionConfiguration configuration = this.createPluginConfiguration(consumerName, repositoryType, resourceLoader);
                counter = new ConfigurationWithCounter(configuration);
                this.configurations.put(consumerRepositoryPair, counter);
            }
        }
        return counter;
    }

    static {
        RepositoryPluginManager.reset();
    }
}

