/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.IConnectionAttributeSetter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class DB2ConnectionAttributeSetter
implements IConnectionAttributeSetter {
    private static final String ATTR_PADDING_FMT = "%1$-16s";
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private static final int PACKAGE_NAME_POS = 0;
    private static final int PACKAGE_NAME_OVERFLOW_POS = 1;
    private static final int MAX_USER_LEN = 16;
    private static final int MAX_SERVER_LEN = 18;
    private static final int MAX_REPORTNAME_LEN = 32;
    private static final int MAX_ACCT_INFO_LEN = 200;

    public void setAttributes(Connection cnx, Properties attributes) throws SQLException {
        try {
            String value = this.encodeAndTruncate(attributes.getProperty("user"), 16);
            cnx.setClientInfo("ClientUser", value);
            value = this.encodeAndTruncate(attributes.getProperty("hostName"), 18);
            cnx.setClientInfo("ClientHostname", value);
            String[] pair = this.encodeAndTruncatePackageName(attributes.getProperty("modelPath"), 32);
            cnx.setClientInfo("ApplicationName", pair[0]);
            this.setAccountingProperty(cnx, attributes, pair[1], 200);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String encodeAndTruncate(String orig, int maxLen) throws Exception {
        String value = orig.replace(' ', ',');
        byte[] bytes = value.getBytes(DEFAULT_CHARSET);
        value = new String(bytes, DEFAULT_CHARSET);
        if (maxLen != -1 && value.length() > maxLen) {
            value = value.substring(0, maxLen);
        }
        return value;
    }

    private String[] encodeAndTruncatePackageName(String orig, int maxLen) throws Exception {
        String[] reportNamePair = new String[2];
        String result = this.encodeAndTruncate(orig, -1);
        if (result.length() > maxLen) {
            reportNamePair[0] = result.substring(0, maxLen);
            reportNamePair[1] = result.substring(maxLen);
        } else {
            reportNamePair[0] = result;
            reportNamePair[1] = "";
        }
        return reportNamePair;
    }

    private void setAccountingProperty(Connection cnx, Properties attributes, String pkgOverflow, int maxLen) throws Exception {
        StringBuilder accountingInfo = new StringBuilder();
        accountingInfo.append("COG ");
        accountingInfo.append(attributes.getProperty("applicationClass"));
        accountingInfo.append(' ');
        accountingInfo.append(attributes.getProperty("version"));
        accountingInfo.append(' ');
        accountingInfo.append(String.format(ATTR_PADDING_FMT, this.encodeAndTruncate(pkgOverflow, 16)));
        accountingInfo.append(' ');
        accountingInfo.append(String.format(ATTR_PADDING_FMT, this.encodeAndTruncate(attributes.getProperty("reportName"), 16)));
        accountingInfo.append(' ');
        accountingInfo.append(String.format(ATTR_PADDING_FMT, this.encodeAndTruncate(attributes.getProperty("queryName"), 16)));
        accountingInfo.append(' ');
        accountingInfo.append(String.format(ATTR_PADDING_FMT, this.encodeAndTruncate(attributes.getProperty("reportPath"), 16)));
        cnx.setClientInfo("ClientAccountingInformation", accountingInfo.toString());
    }
}

