/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.BaseDatabaseMetadataAdaptor;
import com.ibm.cognos.jdbc.adaptor.BaseResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import com.ibm.db2.jcc.cognos.adaptor.DB2DriverDb2AdaptorFactory;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DB2DatabaseMetadataAdaptor
extends BaseDatabaseMetadataAdaptor {
    private static final int DB2_ZOS_COMPATIBLE_NUM = 5;

    public DB2DatabaseMetadataAdaptor(Object obj, AdaptorFactory factory) {
        super((DatabaseMetaData)obj, factory);
    }

    protected int getDatabaseMajorVersionImpl() throws SQLException {
        int pLength;
        String productVersion;
        int indicatorVersion;
        int majorVersion = this.dmd.getDatabaseMajorVersion();
        if ("DSN".equalsIgnoreCase(this.factory.getSubType()) && (indicatorVersion = Integer.parseInt((productVersion = this.dmd.getDatabaseProductVersion()).substring(pLength = productVersion.length() - 1))) < 5) {
            --majorVersion;
        }
        return majorVersion;
    }

    protected ResultSet getFunctionsImpl(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        Object rs = null;
        if (this.dmd.getJDBCMajorVersion() >= 4) {
            rs = this.dmd.getFunctions(catalog, schemaPattern, functionNamePattern);
            rs = new Db2FunctionResultSetAdaptor((ResultSet)rs, this.factory);
        }
        return rs;
    }

    protected ResultSet getTypeInfoImpl() throws SQLException {
        Object rs = null;
        rs = this.dmd.getTypeInfo();
        rs = new Db2getTypeInfoResultSetAdaptor((ResultSet)rs, this.factory);
        return rs;
    }

    public ResultSet getColumnsImpl(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Object rs = this.dmd.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        rs = new Db2getColumnsResultSetAdaptor((ResultSet)rs, this.factory);
        return rs;
    }

    public static class Db2getColumnsResultSetAdaptor
    extends BaseResultSetAdaptor {
        private String columnNameOfDataType = "DATA_TYPE";
        private int columnNumberOfDataType = 5;
        private int columnNumberOfTypeName = 6;

        Db2getColumnsResultSetAdaptor(ResultSet rs, AdaptorFactory f) {
            super(rs, f);
            String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getColumns"));
            if (wrapMetadataRS != null) {
                try {
                    String[] parts = wrapMetadataRS.split(";");
                    this.columnNameOfDataType = parts[0];
                    this.columnNumberOfDataType = Integer.parseInt(parts[1]);
                    this.columnNumberOfTypeName = Integer.parseInt(parts[2]);
                }
                catch (Exception e) {
                    System.out.println("Syntax error detected in adaptor property file.");
                    System.out.printf("Found %s, expected <column name>;<type column index>;<type name column index>%n", wrapMetadataRS);
                }
            }
        }

        public short getShort(int colNo) throws SQLException {
            return (short)this.getInt(colNo);
        }

        public short getShort(String colName) throws SQLException {
            return (short)this.getInt(colName);
        }

        public int getInt(int colNo) throws SQLException {
            int value = this.rs.getInt(colNo);
            if (colNo == this.columnNumberOfDataType && ((DB2DriverDb2AdaptorFactory)this.factory).getIsUnicodeDatabase()) {
                String typeName = this.rs.getString(this.columnNumberOfTypeName);
                if (typeName.equalsIgnoreCase("GRAPHIC")) {
                    if (value == 1) {
                        value = -15;
                    }
                } else if (typeName.equalsIgnoreCase("VARGRAPHIC") && value == 12) {
                    value = -9;
                }
            }
            return value;
        }

        public int getInt(String columnName) throws SQLException {
            if (columnName.equalsIgnoreCase(this.columnNameOfDataType)) {
                return this.getInt(this.columnNumberOfDataType);
            }
            return this.rs.getInt(columnName);
        }
    }

    public static class Db2getTypeInfoResultSetAdaptor
    extends BaseResultSetAdaptor {
        private String columnNameOfDataType = "DATA_TYPE";
        private int columnNumberOfDataType = 2;
        private int columnNumberOfTypeName = 1;

        Db2getTypeInfoResultSetAdaptor(ResultSet rs, AdaptorFactory f) {
            super(rs, f);
            String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getTypeInfo"));
            if (wrapMetadataRS != null) {
                try {
                    String[] parts = wrapMetadataRS.split(";");
                    this.columnNameOfDataType = parts[0];
                    this.columnNumberOfDataType = Integer.parseInt(parts[1]);
                    this.columnNumberOfTypeName = Integer.parseInt(parts[2]);
                }
                catch (Exception e) {
                    System.out.println("Syntax error detected in adaptor property file.");
                    System.out.printf("Found %s, expected <column name>;<type column index>;<type name column index>%n", wrapMetadataRS);
                }
            }
        }

        public short getShort(int colNo) throws SQLException {
            return (short)this.getInt(colNo);
        }

        public short getShort(String colName) throws SQLException {
            return (short)this.getInt(colName);
        }

        public int getInt(int colNo) throws SQLException {
            int value = this.rs.getInt(colNo);
            if (colNo == this.columnNumberOfDataType && ((DB2DriverDb2AdaptorFactory)this.factory).getIsUnicodeDatabase()) {
                String typeName = this.rs.getString(this.columnNumberOfTypeName);
                if (typeName.equalsIgnoreCase("GRAPHIC")) {
                    if (value == 1) {
                        value = -15;
                    }
                } else if (typeName.equalsIgnoreCase("VARGRAPHIC") && value == 12) {
                    value = -9;
                }
            }
            return value;
        }

        public int getInt(String columnName) throws SQLException {
            if (columnName.equalsIgnoreCase(this.columnNameOfDataType)) {
                return this.getInt(this.columnNumberOfDataType);
            }
            return this.rs.getInt(columnName);
        }
    }

    public static class Db2FunctionResultSetAdaptor
    extends BaseResultSetAdaptor {
        Db2FunctionResultSetAdaptor(ResultSet rs, AdaptorFactory f) {
            super(rs, f);
        }

        public String getString(int colNo) throws SQLException {
            if (colNo == 6) {
                return this.rs.getString(5);
            }
            return this.rs.getString(colNo);
        }
    }

    public static final class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new DB2DatabaseMetadataAdaptor((DatabaseMetaData)toWrap, factory);
        }
    }
}

