/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractPropertyLoader;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.ReflectionHelper;
import com.ibm.db2.jcc.cognos.adaptor.DB2ConnectionAdaptor;
import com.ibm.db2.jcc.cognos.adaptor.DB2DatabaseMetadataAdaptor;
import com.ibm.db2.jcc.cognos.adaptor.DB2MetadataMapper;
import com.ibm.db2.jcc.cognos.adaptor.DB2ResultSetAdaptor;
import com.ibm.db2.jcc.cognos.adaptor.DB2ResultSetMetadataAdaptor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DB2DriverDb2AdaptorFactory
extends AdaptorFactory {
    private static volatile AbstractPropertyLoader propertyLoader;
    private static final String STR_TRUE = "true";
    private static final String STR_FALSE = "false";
    private static final String DBTIMESTAMP_CLASSNAME = "com.ibm.db2.jcc.DBTimestamp";
    private static final String DB2CONNECTIONPOOLDATASOURCE_CLASSNAME = "com.ibm.db2.jcc.DB2ConnectionPoolDataSource";
    private static final String DB2POOLEDCONNECTION_CLASSNAME = "com.ibm.db2.jcc.DB2PooledConnection";
    private static final String SQLWARNING_CLASSNAME = "com.ibm.db2.jcc.am.SqlWarning";
    private static final String DB2SQLCA_CLASSNAME = "com.ibm.db2.jcc.DB2Sqlca";
    private static final String GET_DB2_TRUSTED_POOLED_CONNECTION = "getDB2TrustedPooledConnection";
    private static final String GET_DB2_POOLED_CONNECTION = "getDB2PooledConnection";
    private static final String GET_DB2_TRUSTED_POOLED_CONNECTION_PROPERTIES = "getDB2TrustedPooledConnectionProperties";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String SET_ACCESS_TOKEN = "setAccessToken";
    private static final String SET_ACCESS_TOKEN_TYPE = "setAccessTokenType";
    private static final String SET_SECURITY_MECHANISM = "setSecurityMechanism";
    private static final Short TOKEN_SECURITY;
    private Method toDBStringMethod = null;
    private DB2PooledConnectionHelper db2PooledConnectionHelper;
    private byte[] cookie = new byte[1];
    private Properties connProperties;
    private boolean isBigSQL = false;
    private boolean isDashDB = false;
    private boolean isUnicodeDatabase = false;

    protected void setPropertyLoader(AbstractPropertyLoader loader) {
        propertyLoader = loader;
    }

    public AbstractPropertyLoader getPropertyLoader() {
        return propertyLoader;
    }

    protected void registerWrappers() {
        this.setDatabaseMetadataWrapper(new DB2DatabaseMetadataAdaptor.Wrapper());
        this.setResultSetWrapper(new DB2ResultSetAdaptor.Wrapper());
        this.setConnectionWrapper(new DB2ConnectionAdaptor.Wrapper());
        this.setMetadataMapper(new DB2MetadataMapper(this));
        this.setResultSetMetadataWrapper(new DB2ResultSetMetadataAdaptor.Wrapper());
    }

    /*
     * Unable to fully structure code
     */
    public Connection connect(Driver driver, String url, Properties driverProperties, Properties ibmCognosProperties) throws SQLException {
        connection = null;
        partypes = new Class[]{Boolean.TYPE};
        try {
            this.setToDBStringMethod(Class.forName("com.ibm.db2.jcc.DBTimestamp").getMethod("toDBString", partypes));
        }
        catch (Exception e) {
            this.setToDBStringMethod(null);
        }
        driverProperties.put("retrieveMessagesFromServerOnGetMessage", "true");
        driverProperties.put("emulateParameterMetaDataForZCalls", "true");
        if (this.getToDBStringMethod() != null) {
            driverProperties.put("timestampOutputType", "2");
        }
        if (url.contains("ibmcognos.authentication=java_krb5") || ibmCognosProperties.getProperty("ibmcognos.authentication") == "java_krb5") {
            try {
                System.setProperty("javax.security.auth.useSubjectCredsOnly", "true");
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        if (ibmCognosProperties != null && ibmCognosProperties.getProperty("ibmcognos.decfloat") != null) {
            decfloat = "true".compareToIgnoreCase(ibmCognosProperties.getProperty("ibmcognos.decfloat")) == 0;
            ((DB2MetadataMapper)this.getMetadataMapper()).setDecfloat(decfloat);
        }
        if (url.contains("ibmcognos.decfloat=true")) {
            ((DB2MetadataMapper)this.getMetadataMapper()).setDecfloat(true);
        } else if (url.contains("ibmcognos.decfloat=false")) {
            ((DB2MetadataMapper)this.getMetadataMapper()).setDecfloat(false);
        }
        if (driverProperties.getProperty("trustedContext") == null && driverProperties.getProperty("accessToken") == null) {
            connection = driver.connect(url, driverProperties);
            warn = connection.getWarnings();
            try {
                aClass = Class.forName("com.ibm.db2.jcc.am.SqlWarning");
                if (warn == null || !aClass.isInstance(warn) || (db2Sqlca = (db2SqlWarningHelper = new DB2SqlWarningHelper(connection.getWarnings())).getSqlca()) == null) ** GOTO lbl125
                db2SqlcaHelper = new DB2SqlcaHelper(db2Sqlca);
                sqlErrmcTokens = db2SqlcaHelper.getSqlErrmcTokens();
                sqlWarn = db2SqlcaHelper.getSqlWarn();
                if (Integer.parseInt(sqlErrmcTokens[9]) > 0 && 'B' == sqlWarn[7]) {
                    this.isBigSQL = true;
                }
                if (sqlWarn[7] != 'D') ** GOTO lbl125
                this.isDashDB = true;
            }
            catch (ClassNotFoundException aClass) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            driverProperties.remove("trustedContext");
            db2ConnectionPoolDataSourceHelper = null;
            try {
                aClass = Class.forName("com.ibm.db2.jcc.DB2ConnectionPoolDataSource");
                db2ConnectionPoolDataSourceHelper = new DB2ConnectionPoolDataSourceHelper(aClass.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            parts = url.substring(url.indexOf("//") + 2);
            addresstoken = parts.split("/", 2);
            servertoken = addresstoken[0].split(":");
            dbtoken = addresstoken[1].split(":", 2);
            db2ConnectionPoolDataSourceHelper.setServerName(servertoken[0]);
            db2ConnectionPoolDataSourceHelper.setPortNumber(Integer.valueOf(servertoken[1]));
            db2ConnectionPoolDataSourceHelper.setDatabaseName(dbtoken[0]);
            db2ConnectionPoolDataSourceHelper.setDriverType(4);
            oidcAccessToken = driverProperties.getProperty("accessToken");
            v0 = bOIDCAuthentication = oidcAccessToken != null;
            if (bOIDCAuthentication) {
                driverProperties.remove("accessToken");
                db2ConnectionPoolDataSourceHelper.setSecurityMechanism(DB2DriverDb2AdaptorFactory.TOKEN_SECURITY);
                db2ConnectionPoolDataSourceHelper.setAccessToken(oidcAccessToken);
                db2ConnectionPoolDataSourceHelper.setAccessTokenType("JWT");
            }
            if (dbtoken.length == 2) {
                for (String propertytoken : propertytokens = dbtoken[1].split(";")) {
                    property = propertytoken.split("=", 2);
                    if (property.length < 2) continue;
                    pName = property[0];
                    pValue = property[1];
                    if ("specialRegisters".equals(pName)) {
                        prop = new Properties();
                        for (String pair : pValue.split(",")) {
                            prop.put(pair.split("=")[0], pair.split("=")[1]);
                        }
                        db2ConnectionPoolDataSourceHelper.setSpecialRegisters(prop);
                        continue;
                    }
                    if ("globalSessionVariables".equals(pName)) {
                        prop = new Properties();
                        for (String pair : pValue.split(",")) {
                            prop.put(pair.split("=")[0], pair.split("=")[1]);
                        }
                        db2ConnectionPoolDataSourceHelper.setGlobalSessionVariables(prop);
                        continue;
                    }
                    if ("queryAcceleration".equals(pName)) {
                        db2ConnectionPoolDataSourceHelper.setQueryAcceleration(pValue);
                        continue;
                    }
                    driverProperties.put(pName, pValue);
                }
            }
            if (bOIDCAuthentication) {
                driverProperties.remove("user");
                driverProperties.remove("password");
            }
            objects = null;
            maxAttempts = 3;
            connected = false;
            for (attempt = 1; !connected && attempt <= 3; ++attempt) {
                try {
                    if (bOIDCAuthentication) {
                        conn = db2ConnectionPoolDataSourceHelper.getDB2PooledConnection(null, null, driverProperties);
                        this.db2PooledConnectionHelper = new DB2PooledConnectionHelper(conn);
                    } else {
                        objects = db2ConnectionPoolDataSourceHelper.getDB2TrustedPooledConnection(driverProperties.getProperty("user"), driverProperties.getProperty("password"), driverProperties);
                        this.db2PooledConnectionHelper = new DB2PooledConnectionHelper(objects[0]);
                        this.cookie = (byte[])objects[1];
                    }
                    connected = true;
                    continue;
                }
                catch (SQLException e) {
                    if (attempt != 3) continue;
                    throw e;
                }
            }
            connection = this.db2PooledConnectionHelper.getConnection();
            this.connProperties = driverProperties;
        }
lbl125:
        // 5 sources

        this.determineUnicodeDatabase(connection);
        return connection;
    }

    public void setToDBStringMethod(Method toDBStringMethod) {
        this.toDBStringMethod = toDBStringMethod;
    }

    public Method getToDBStringMethod() {
        return this.toDBStringMethod;
    }

    public boolean getIsUnicodeDatabase() {
        return this.isUnicodeDatabase;
    }

    public Connection getDB2Connection(String user, String password, String registry) throws SQLException {
        return this.db2PooledConnectionHelper.getDB2Connection(this.cookie, user, password, registry, null, null, this.connProperties);
    }

    public Connection getConnection() throws SQLException {
        return this.db2PooledConnectionHelper.getConnection();
    }

    protected void determineSubType(Connection connection) throws SQLException {
        if (this.isBigSQL) {
            this.setSubType("bigsql");
        } else if (this.isDashDB) {
            this.setSubType("dashdb");
        } else {
            super.determineSubType(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineUnicodeDatabase(Connection connection) throws SQLException {
        this.determineSubType(connection);
        if (this.getSubType() != null && !this.getSubType().equalsIgnoreCase("SQL")) {
            return;
        }
        Statement st = null;
        ResultSet rset = null;
        try {
            int codepage;
            String sql = "SELECT value FROM SYSIBMADM.DBCFG where name in ('codepage')";
            st = connection.createStatement();
            rset = st.executeQuery(sql);
            if (rset.next() && ((codepage = rset.getInt(1)) == 1200 || codepage == 1208)) {
                this.isUnicodeDatabase = true;
            }
        }
        catch (SQLException e) {
            System.out.println("Failed to execute the query: SELECT value FROM SYSIBMADM.DBCFG where name in ('codepage')");
            System.out.println(e.getMessage());
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                    rset = null;
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                    st = null;
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    static {
        TOKEN_SECURITY = 19;
    }

    private class DB2SqlcaHelper {
        private final ReflectionHelper rh = new ReflectionHelper("com.ibm.db2.jcc.DB2Sqlca");
        private final Object o;

        public DB2SqlcaHelper(Object object) {
            this.o = object;
            this.rh.registerMethod("getSqlErrmcTokens", null);
            this.rh.registerMethod("getSqlWarn", null);
        }

        public String[] getSqlErrmcTokens() throws SQLException {
            return (String[])this.rh.invokeJDBCMethod(this.o, "getSqlErrmcTokens", new Object[0]);
        }

        public char[] getSqlWarn() throws SQLException {
            return (char[])this.rh.invokeJDBCMethod(this.o, "getSqlWarn", new Object[0]);
        }
    }

    private class DB2SqlWarningHelper {
        private final ReflectionHelper rh = new ReflectionHelper("com.ibm.db2.jcc.am.SqlWarning");
        private final Object o;

        public DB2SqlWarningHelper(Object object) {
            this.o = object;
            this.rh.registerMethod("getSqlca", null);
        }

        public Object getSqlca() throws SQLException {
            return this.rh.invokeJDBCMethod(this.o, "getSqlca", new Object[0]);
        }
    }

    private class DB2PooledConnectionHelper {
        private final ReflectionHelper rh = new ReflectionHelper("com.ibm.db2.jcc.DB2PooledConnection");
        private final Object o;

        public DB2PooledConnectionHelper(Object object) {
            this.o = object;
            Class[] type = new Class[]{byte[].class, String.class, String.class, String.class, byte[].class, String.class, Properties.class};
            this.rh.registerMethod("getDB2Connection", type);
            this.rh.registerMethod("getConnection", null);
        }

        public Connection getDB2Connection(byte[] cookie, String user, String password, String userRegistry, byte[] userSecToken, String originalUser, Properties properties) throws SQLException {
            return (Connection)this.rh.invokeJDBCMethod(this.o, "getDB2Connection", new Object[]{cookie, user, password, userRegistry, userSecToken, originalUser, properties});
        }

        public Connection getConnection() throws SQLException {
            return (Connection)this.rh.invokeJDBCMethod(this.o, "getConnection", new Object[0]);
        }
    }

    private class DB2ConnectionPoolDataSourceHelper {
        private final ReflectionHelper rh = new ReflectionHelper("com.ibm.db2.jcc.DB2ConnectionPoolDataSource");
        private final Object o;

        public DB2ConnectionPoolDataSourceHelper(Object object) {
            this.o = object;
            Class[] sType = new Class[]{String.class};
            this.rh.registerMethod("setServerName", sType);
            this.rh.registerMethod("setDatabaseName", sType);
            this.rh.registerMethod("setQueryAcceleration", sType);
            this.rh.registerMethod(DB2DriverDb2AdaptorFactory.SET_ACCESS_TOKEN, sType);
            this.rh.registerMethod(DB2DriverDb2AdaptorFactory.SET_ACCESS_TOKEN_TYPE, sType);
            this.rh.registerMethod("setTraceFile", sType);
            Class[] iType = new Class[]{Integer.TYPE};
            this.rh.registerMethod("setDriverType", iType);
            this.rh.registerMethod("setPortNumber", iType);
            this.rh.registerMethod("setTraceLevel", iType);
            Class[] shortType = new Class[]{Short.TYPE};
            this.rh.registerMethod(DB2DriverDb2AdaptorFactory.SET_SECURITY_MECHANISM, shortType);
            Class[] typesForTrustedPooledConnection = new Class[]{String.class, String.class, Properties.class};
            this.rh.registerMethod(DB2DriverDb2AdaptorFactory.GET_DB2_TRUSTED_POOLED_CONNECTION, typesForTrustedPooledConnection);
            this.rh.registerMethod(DB2DriverDb2AdaptorFactory.GET_DB2_POOLED_CONNECTION, typesForTrustedPooledConnection);
            Class[] typesForTrustedPooledConnectionProperties = new Class[]{Properties.class};
            this.rh.registerMethod(DB2DriverDb2AdaptorFactory.GET_DB2_TRUSTED_POOLED_CONNECTION_PROPERTIES, DB2DriverDb2AdaptorFactory.GET_DB2_TRUSTED_POOLED_CONNECTION, typesForTrustedPooledConnectionProperties);
            Class[] pType = new Class[]{Properties.class};
            this.rh.registerMethod("setSpecialRegisters", pType);
            this.rh.registerMethod("setGlobalSessionVariables", pType);
        }

        public void setServerName(String serverName) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "setServerName", new Object[]{serverName});
        }

        public void setTraceFile(String fileName) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "setTraceFile", new Object[]{fileName});
        }

        public void setDatabaseName(String databaseName) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "setDatabaseName", new Object[]{databaseName});
        }

        public void setDriverType(int type) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "setDriverType", new Object[]{type});
        }

        public void setTraceLevel(int traceLevel) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "setTraceLevel", new Object[]{traceLevel});
        }

        public void setPortNumber(int portNo) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "setPortNumber", new Object[]{portNo});
        }

        public void setAccessToken(String accessToken) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, DB2DriverDb2AdaptorFactory.SET_ACCESS_TOKEN, new Object[]{accessToken});
        }

        public void setAccessTokenType(String accessTokenType) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, DB2DriverDb2AdaptorFactory.SET_ACCESS_TOKEN_TYPE, new Object[]{accessTokenType});
        }

        public void setSecurityMechanism(short param) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, DB2DriverDb2AdaptorFactory.SET_SECURITY_MECHANISM, new Object[]{param});
        }

        public Object[] getDB2TrustedPooledConnection(String userID, String passWD, Properties properties) throws SQLException {
            return (Object[])this.rh.invokeJDBCMethod(this.o, DB2DriverDb2AdaptorFactory.GET_DB2_TRUSTED_POOLED_CONNECTION, new Object[]{userID, passWD, properties});
        }

        public Object[] getDB2TrustedPooledConnection(Properties properties) throws SQLException {
            return (Object[])this.rh.invokeJDBCMethod(this.o, DB2DriverDb2AdaptorFactory.GET_DB2_TRUSTED_POOLED_CONNECTION_PROPERTIES, new Object[]{properties});
        }

        public Object getDB2PooledConnection(String userID, String passWD, Properties properties) throws SQLException {
            return this.rh.invokeJDBCMethod(this.o, DB2DriverDb2AdaptorFactory.GET_DB2_POOLED_CONNECTION, new Object[]{userID, passWD, properties});
        }

        public void setSpecialRegisters(Properties prop) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "setSpecialRegisters", new Object[]{prop});
        }

        public void setGlobalSessionVariables(Properties prop) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "setGlobalSessionVariables", new Object[]{prop});
        }

        public void setQueryAcceleration(String accelerationSetting) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "setQueryAcceleration", new Object[]{accelerationSetting});
        }
    }
}

