/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.AdaptorMethodOverride;
import com.ibm.cognos.jdbc.adaptor.BaseResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import com.ibm.db2.jcc.cognos.adaptor.DB2DriverDb2AdaptorFactory;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DB2ResultSetAdaptor
extends BaseResultSetAdaptor {
    private static final String DSN_TIMESTAMPTZ_SPLITTER = "\\W+";
    private static final String DSN_TIMESTAMPTZ_FORMATTER_PLUS = "%1$s-%2$s-%3$s %4$s:%5$s:%6$s.%7$s+%8$s:%9$s";
    private static final String DSN_TIMESTAMPTZ_FORMATTER_MINUS = "%1$s-%2$s-%3$s %4$s:%5$s:%6$s.%7$s-%8$s:%9$s";

    public DB2ResultSetAdaptor(ResultSet rs, AdaptorFactory factory) {
        super(rs, factory);
    }

    @AdaptorMethodOverride
    public String getExtendedData(int type, int column) throws SQLException {
        if (type != -1001) {
            return super.getExtendedData(type, column);
        }
        Method x = ((DB2DriverDb2AdaptorFactory)this.factory).getToDBStringMethod();
        ResultSet rs = this.getResultSet();
        String s = null;
        if (x != null) {
            Object o = rs.getObject(column);
            if (o == null) {
                return null;
            }
            try {
                s = (String)x.invoke(o, new Boolean(true));
            }
            catch (Exception e) {
                s = rs.getString(column);
            }
        } else {
            s = rs.getString(column);
        }
        String[] parts = s.split(DSN_TIMESTAMPTZ_SPLITTER);
        s = s.indexOf(43) >= 0 ? String.format(DSN_TIMESTAMPTZ_FORMATTER_PLUS, parts) : String.format(DSN_TIMESTAMPTZ_FORMATTER_MINUS, parts);
        return s;
    }

    private ResultSet getResultSet() {
        return this.rs;
    }

    public static class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new DB2ResultSetAdaptor((ResultSet)toWrap, factory);
        }
    }
}

