/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.BaseMetadataMapper;

public class InformixMetadataMapper
extends BaseMetadataMapper {
    private static final int INFORMIX_FLOATPOINT_SCALE = 255;

    InformixMetadataMapper(AdaptorFactory theFactory) {
        super(theFactory);
    }

    public int mapType(int origType, String origTypeName, int origPrecision, int origScale) {
        if (origTypeName != null && origTypeName.equalsIgnoreCase("DECIMAL")) {
            if (origScale == 255) {
                return super.mapType(8, "DOUBLE", 0, 0);
            }
        } else if (origTypeName != null && origTypeName.equalsIgnoreCase("INTERVAL")) {
            int adaptorType = this.calculateAdaptorType(origType, origPrecision);
            return adaptorType;
        }
        return super.mapType(origType, origTypeName, origPrecision, origScale);
    }

    public int mapPrecision(int origType, String origTypeName, int origPrecision, int origScale) {
        if (origTypeName != null && !origTypeName.equalsIgnoreCase("INTERVAL")) {
            return super.mapPrecision(origType, origTypeName, origPrecision, origScale);
        }
        int precision = origPrecision / 256;
        int adaptorType = this.calculateAdaptorType(origType, origPrecision);
        if (adaptorType == origType) {
            return super.mapPrecision(origType, origTypeName, origPrecision, origScale);
        }
        int subtract = 0;
        switch (adaptorType) {
            case -1011: 
            case -1007: 
            case -1004: {
                subtract = 2;
                break;
            }
            case -1008: {
                subtract = 4;
                break;
            }
            case -1009: {
                subtract = 6 + this.fractions(origPrecision % 256 % 16);
                break;
            }
            case -1012: {
                subtract = 4 + this.fractions(origPrecision % 256 % 16);
                break;
            }
            case -1014: {
                subtract = 2 + this.fractions(origPrecision % 256 % 16);
                break;
            }
            case -1015: {
                subtract = this.fractions(origPrecision % 256 / 16);
                break;
            }
        }
        return precision > subtract ? precision - subtract : 0;
    }

    private int fractions(int i) {
        return i > 10 ? i - 10 : 0;
    }

    private int calculateAdaptorType(int origType, int origPrecision) {
        int typecode = origPrecision % 256;
        int from = typecode / 16;
        int to = typecode % 16;
        int adaptorType = origType;
        block0 : switch (from) {
            case 0: {
                switch (to) {
                    case 2: {
                        adaptorType = -1004;
                        break block0;
                    }
                }
                adaptorType = -1003;
                break;
            }
            case 2: {
                adaptorType = -1005;
                break;
            }
            case 4: {
                switch (to) {
                    case 6: {
                        adaptorType = -1007;
                        break block0;
                    }
                    case 8: {
                        adaptorType = -1008;
                        break block0;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        adaptorType = -1009;
                        break block0;
                    }
                }
                adaptorType = -1006;
                break;
            }
            case 6: {
                switch (to) {
                    case 8: {
                        adaptorType = -1011;
                        break block0;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        adaptorType = -1012;
                        break block0;
                    }
                }
                adaptorType = -1010;
                break;
            }
            case 8: {
                switch (to) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        adaptorType = -1014;
                        break block0;
                    }
                }
                adaptorType = -1013;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                adaptorType = -1015;
            }
        }
        return adaptorType;
    }
}

