/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import java.util.Properties;
import java.util.regex.Pattern;

public class BaseMetadataMapper {
    public static final String WRAP_METADATA_RESULT_SET_FRMT = "adaptor.wrap.metadata.resultset.%1$s";
    public static final String OVERRIDE_PROP_PREFIX = "adaptor.method.override.%1$s";
    public static final String DATATYPE_MAP_FRMT = "data.type.mapping.%1$s";
    public static final String DATATYPE_MAP_FILTER = "data.type.mapping.filter";
    public static final String DATATYPE_MAX_PREC = "data.type.max.precision.%1$s";
    public final AdaptorFactory factory;
    Pattern filter = null;

    public BaseMetadataMapper(AdaptorFactory theFactory) {
        this.factory = theFactory;
    }

    public int mapType(int origType, String origTypeName, int origPrecision, int origScale) {
        return this.mapType(origType, origTypeName, origPrecision);
    }

    public int mapType(int origType, String origTypeName, int origPrecision) {
        return this.mapType(origType, origTypeName);
    }

    public int mapType(int origType, String origTypeName) {
        int type = origType;
        String override = this.getProperties().getProperty(String.format(DATATYPE_MAP_FRMT, origType));
        if (override == null && origTypeName != null) {
            if (this.filter == null) {
                override = this.getProperties().getProperty(String.format(DATATYPE_MAP_FRMT, origTypeName.replace(' ', '_')));
            } else {
                String[] parts = this.filter.split(origTypeName);
                StringBuilder buf = new StringBuilder();
                boolean isFirst = true;
                for (String part : parts) {
                    if (part.length() == 0) continue;
                    if (!isFirst) {
                        buf.append('_');
                    } else {
                        isFirst = false;
                    }
                    buf.append(part);
                }
                override = this.getProperties().getProperty(String.format(DATATYPE_MAP_FRMT, buf.toString().replace(' ', '_')));
            }
        }
        if (override != null) {
            type = Integer.parseInt(override);
        }
        return type;
    }

    public int mapPrecision(int origType, String origTypeName, int origPrecision, int origScale) {
        return this.mapPrecision(origType, origTypeName, origPrecision);
    }

    public int mapPrecision(int origType, String origTypeName, int origPrecision) {
        int precision = origPrecision;
        String str = this.getProperties().getProperty(String.format(DATATYPE_MAX_PREC, origType));
        if (str != null) {
            precision = Math.min(precision, Integer.parseInt(str));
        }
        return precision;
    }

    public int mapScale(int origType, String origTypeName, int origPrecision, int origScale) {
        return origScale;
    }

    private Properties getProperties() {
        String regex;
        Properties properties = this.factory.getAdaptorProperties();
        if (this.filter == null && (regex = properties.getProperty(DATATYPE_MAP_FILTER)) != null) {
            this.filter = Pattern.compile(regex);
        }
        return properties;
    }
}

