/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractPropertyLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarFilePropertyLoader
extends AbstractPropertyLoader {
    private String jarfilename;
    private String version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarFilePropertyLoader(String jfn) {
        this.jarfilename = jfn;
        JarFile jar = null;
        try {
            jar = new JarFile(this.jarfilename);
            this.version = jar.getManifest().getMainAttributes().getValue("Implementation-Version");
            if (this.version == null) {
                this.version = "unknown";
            }
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (!entryName.matches(".*AdaptorFactory.*\\.xml$")) continue;
                this.propertiesCache.put(entryName.substring("res/".length(), entryName.length() - ".xml".length()), null);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected InputStream getPropertyInputStream(String name) {
        JarFile jar = null;
        InputStream is = null;
        try {
            jar = new JarFile(this.jarfilename);
            String entryName = "res/" + name + ".xml";
            is = jar.getInputStream(jar.getEntry(entryName));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return is;
    }

    @Override
    protected String getResourceLocation() {
        return this.jarfilename;
    }

    @Override
    public String getResourceVersion() {
        return this.version;
    }
}

