/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.HashMap;

public final class ReflectionHelper {
    private final String className;
    private final HashMap<String, Method> methods = new HashMap();
    private final HashMap<String, Field> fields = new HashMap();
    private static final String UNSUPPORTED_OPERATION_FORMAT = "The requested operation is not supported: [%s]";

    public ReflectionHelper(String cname) {
        this.className = cname;
    }

    public boolean registerMethod(String methodSignature, String methodName, Class<?>[] parametertypes) {
        boolean rc = false;
        try {
            Method m = Class.forName(this.className).getMethod(methodName, parametertypes);
            if (Modifier.isPublic(m.getModifiers())) {
                this.methods.put(methodSignature, m);
                rc = true;
            }
        }
        catch (Exception e) {
            rc = false;
        }
        return rc;
    }

    public boolean registerMethod(String methodName, Class<?>[] parametertypes) {
        return this.registerMethod(methodName, methodName, parametertypes);
    }

    public boolean registerField(String fieldName) {
        boolean rc = false;
        try {
            Field f = Class.forName(this.className).getField(fieldName);
            if (Modifier.isPublic(f.getModifiers())) {
                this.fields.put(fieldName, f);
                rc = true;
            }
        }
        catch (Exception e) {
            rc = false;
        }
        return rc;
    }

    public Object invokeMethod(Object object, String methodName, Object ... args) throws Throwable {
        Method method = this.methods.get(methodName);
        if (null == method) {
            throw new UnsupportedOperationException(String.format(UNSUPPORTED_OPERATION_FORMAT, methodName));
        }
        try {
            return method.invoke(object, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public Object invokeJDBCMethod(Object object, String methodSignature, Object ... args) throws SQLException {
        try {
            return this.invokeMethod(object, methodSignature, args);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (UnsupportedOperationException u) {
            throw u;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public Object getField(Object object, String fieldName) throws Throwable {
        return this.fields.get(fieldName).get(object);
    }

    public Object getField(Object object, String fieldName, Object defaultValue) {
        try {
            return this.fields.get(fieldName).get(object);
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    public void setField(Object object, String fieldName, Object newValue) throws Throwable {
        this.fields.get(fieldName).set(object, newValue);
    }

    public boolean setFieldNoException(Object object, String fieldName, Object newValue) {
        try {
            this.fields.get(fieldName).set(object, newValue);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }
}

