/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.AdaptorMethodOverride;
import com.ibm.cognos.jdbc.adaptor.BaseConnectionAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class NetezzaConnectionAdaptor
extends BaseConnectionAdaptor {
    public NetezzaConnectionAdaptor(Connection connection, AdaptorFactory factory) {
        super(connection, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AdaptorMethodOverride(checkForSqlOverride=false)
    public String getQueryPlan(String query) throws SQLException {
        String plan = null;
        try (Statement stmt = null;){
            stmt = this.getConnection().createStatement();
            stmt.execute("EXPLAIN VERBOSE " + query);
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                StringBuilder builder = new StringBuilder();
                builder.append("<![CDATA[\n");
                builder.append(warning.getLocalizedMessage());
                builder.append("\n]]>");
                plan = builder.toString();
            }
        }
        return plan;
    }

    public static class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new NetezzaConnectionAdaptor((Connection)toWrap, factory);
        }
    }
}

