/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractPropertyLoader;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.postgresql.cognos.adaptor.PostgresDatabaseMetadataAdaptor;
import org.postgresql.cognos.adaptor.PostgresMetadataMapper;

public class DriverPostgresqlAdaptorFactory
extends AdaptorFactory {
    private static final String GREENPLUM = "greenplum";
    private static volatile AbstractPropertyLoader propertyLoader;
    private String serverType = "UNKNOWN";

    protected void setPropertyLoader(AbstractPropertyLoader loader) {
        propertyLoader = loader;
    }

    public AbstractPropertyLoader getPropertyLoader() {
        return propertyLoader;
    }

    protected void registerWrappers() {
        this.setDatabaseMetadataWrapper(new PostgresDatabaseMetadataAdaptor.Wrapper());
        this.setMetadataMapper(new PostgresMetadataMapper(this));
    }

    public Connection connect(Driver driver, String url, Properties driverProperties, Properties ibmCognosProperties) throws SQLException {
        Connection connection = null;
        try {
            connection = driver.connect(url, driverProperties);
            connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            SQLException exn = this.processSQLException(ex);
            throw exn;
        }
        return connection;
    }

    protected void determineSubType(Connection connection) throws SQLException {
        this.checkPostgresSQLSubType(connection);
        if (this.serverType.equals(GREENPLUM)) {
            this.setSubType(this.serverType);
        } else {
            super.determineSubType(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPostgresSQLSubType(Connection connection) {
        Statement st = null;
        try {
            st = connection.createStatement();
            st.execute("select version()");
            ResultSet rs = st.getResultSet();
            String s = null;
            if (rs != null) {
                while (rs.next()) {
                    s = rs.getString(1);
                }
                rs.close();
                if (s.toLowerCase().contains(GREENPLUM)) {
                    this.serverType = GREENPLUM;
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

