/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IntegerLiteralExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NegateExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import java.util.Enumeration;
import java.util.Vector;

public class AdditiveExpression
extends Expression {
    private Vector<IExpression> m_subExpressions = new Vector();

    public void add(IExpression sub) {
        this.m_subExpressions.add(sub);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        BooleanValue newChanged = new BooleanValue(false);
        do {
            Expression child;
            IExpression ex;
            newChanged.set(false);
            AdditiveExpression.optimizeExpressionSubtree(this.m_subExpressions, newChanged);
            int i = 0;
            while (i < this.m_subExpressions.size()) {
                ex = this.m_subExpressions.get(i);
                if (!(ex instanceof AdditiveExpression)) {
                    ++i;
                    continue;
                }
                this.m_subExpressions.removeElementAt(i);
                child = (AdditiveExpression)ex;
                this.m_subExpressions.addAll(i, ((AdditiveExpression)child).m_subExpressions);
                newChanged.set(true);
            }
            i = 0;
            while (i < this.m_subExpressions.size() && this.m_subExpressions.size() == 1) {
                ex = this.m_subExpressions.get(i);
                if (!(ex instanceof IntegerLiteralExpression)) {
                    ++i;
                    continue;
                }
                child = (IntegerLiteralExpression)ex;
                if (((IntegerLiteralExpression)child).intValue() == 0L) {
                    newChanged.set(true);
                    this.m_subExpressions.remove(i);
                    continue;
                }
                ++i;
            }
            if (this.m_subExpressions.size() == 1) {
                changed.set(true);
                IExpression result = this.m_subExpressions.get(0);
                return result;
            }
            if (!newChanged.get()) continue;
            changed.set(true);
        } while (newChanged.get());
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        int nb = this.m_subExpressions.size();
        for (int i = 0; i < nb; ++i) {
            IExpression subExpression = this.m_subExpressions.get(i);
            if (i == 0) {
                this.appendHelper(buffer, subExpression, context);
                continue;
            }
            if (subExpression instanceof NegateExpression) {
                NegateExpression neg = (NegateExpression)subExpression;
                subExpression = neg.getSubExpressions().nextElement();
                buffer.append(" - ");
                super.appendHelper(buffer, subExpression, context);
                continue;
            }
            if (subExpression instanceof IntegerLiteralExpression) {
                IntegerLiteralExpression intExpr = (IntegerLiteralExpression)subExpression;
                long value = intExpr.intValue();
                if (value < 0L) {
                    buffer.append(" - ");
                    buffer.append(-value);
                    continue;
                }
                buffer.append(" + ");
                buffer.append(value);
                continue;
            }
            buffer.append(" + ");
            this.appendHelper(buffer, subExpression, context);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AdditiveExpression)) {
            return false;
        }
        AdditiveExpression otherExpr = (AdditiveExpression)other;
        return AdditiveExpression.sameSetHelper(this.m_subExpressions, otherExpr.m_subExpressions);
    }

    @Override
    public int getNbSubExpressions() {
        return this.m_subExpressions.size();
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.m_subExpressions.size()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.m_subExpressions.get(fragmentNb);
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.m_subExpressions.size()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.m_subExpressions.set(fragmentNb, (IExpression)fragment);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.m_subExpressions != null) {
            result ^= this.m_subExpressions.hashCode();
        }
        return result;
    }

    @Override
    public ExpressionType getType() throws InvalidTypeException {
        if (this.hasType(ExpressionType.STRING)) {
            this.checkSubexpressionType(ExpressionType.STRING);
            return ExpressionType.STRING;
        }
        if (this.hasType(ExpressionType.NUMERIC)) {
            this.checkSubexpressionType(ExpressionType.NUMERIC);
            return ExpressionType.NUMERIC;
        }
        return ExpressionType.UNKNOWN;
    }

    private boolean hasType(ExpressionType type) throws InvalidTypeException {
        Enumeration<IExpression> subEnumeration = this.getSubExpressions();
        while (subEnumeration.hasMoreElements()) {
            IExpression sub = subEnumeration.nextElement();
            ExpressionType subType = sub.getType();
            if (subType != type) continue;
            return true;
        }
        return false;
    }
}

