/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Clause;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;

public class AdditiveExpressionSort
extends Clause {
    private IExpression m_subExpression;
    private String m_sortOrder;

    public AdditiveExpressionSort(IExpression expr, String sortOrder) {
        this.m_subExpression = expr;
        this.m_sortOrder = sortOrder;
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    Clause optimize(BooleanValue changed) throws ParseTreeException {
        this.m_subExpression = this.m_subExpression.optimize(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        this.appendHelper(buffer, this.m_subExpression, context);
        if (null != this.m_sortOrder) {
            buffer.append(' ');
            buffer.append(this.m_sortOrder);
        }
    }

    @Override
    protected boolean needWrapping(IExpressionFragment fragment, ExpressionFragment.AppendContext context) {
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AdditiveExpressionSort)) {
            return false;
        }
        AdditiveExpressionSort otherExpr = (AdditiveExpressionSort)other;
        if (!AdditiveExpressionSort.equalsHelper(this.m_sortOrder, otherExpr.m_sortOrder)) {
            return false;
        }
        return AdditiveExpressionSort.equalsHelper(this.m_subExpression, otherExpr.m_subExpression);
    }

    @Override
    public int getNbSubExpressions() {
        if (this.m_subExpression != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.m_subExpression;
    }

    public String getSortOrder() {
        return this.m_sortOrder;
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.m_subExpression = (IExpression)fragment;
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.m_subExpression != null) {
            result ^= this.m_subExpression.hashCode();
        }
        if (this.m_sortOrder != null) {
            result ^= this.m_sortOrder.hashCode();
        }
        return result;
    }
}

