/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Clause;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionList;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;

public class BreakClauses
extends Clause {
    private boolean auto;
    private boolean report;
    private boolean all;
    private boolean any;
    private ExpressionList terms;

    public BreakClauses(boolean auto, boolean report, boolean all, boolean any, ExpressionList terms) {
        this.auto = auto;
        this.report = report;
        this.all = all;
        this.any = any;
        this.terms = terms;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BreakClauses)) {
            return false;
        }
        BreakClauses o = (BreakClauses)other;
        if (this.auto != o.auto) {
            return false;
        }
        if (this.auto != o.auto) {
            return false;
        }
        if (this.report != o.report) {
            return false;
        }
        if (this.all != o.all) {
            return false;
        }
        if (this.any != o.any) {
            return false;
        }
        return this.terms == o.terms || this.terms.equals(o.terms);
    }

    @Override
    public int getNbSubExpressions() {
        if (this.terms == null) {
            return 0;
        }
        return this.terms.getNbSubExpressions();
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.terms.getSubExpression(fragmentNb);
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.terms.setSubExpression(fragmentNb, fragment);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    Clause optimize(BooleanValue changed) {
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        if (this.auto) {
            buffer.append(" AUTO ");
        } else if (this.report) {
            buffer.append(" FOR REPORT ");
        } else if (this.terms != null) {
            buffer.append(" FOR ");
            if (this.all) {
                buffer.append("ALL ");
            } else if (this.any) {
                buffer.append("ANY ");
            }
            if (this.terms != null) {
                this.appendHelper(buffer, this.terms, context);
            }
        }
    }

    @Override
    public int hashCode() {
        int booleanValuesHash;
        int booleanValues = 0;
        if (this.auto) {
            ++booleanValues;
        }
        booleanValues *= 2;
        if (this.report) {
            ++booleanValues;
        }
        booleanValues *= 2;
        if (this.all) {
            ++booleanValues;
        }
        booleanValues *= 2;
        if (this.any) {
            ++booleanValues;
        }
        Integer booleanValuesObject = new Integer(booleanValues);
        int result = booleanValuesHash = booleanValuesObject.hashCode();
        if (this.terms != null) {
            int termsHash = this.terms.hashCode();
            result = result << 1 ^ termsHash;
        }
        int classHash = this.getClass().hashCode();
        result = result << 1 ^ classHash;
        return result;
    }

    public boolean getAuto() {
        return this.auto;
    }

    public boolean getReport() {
        return this.report;
    }

    public boolean getAll() {
        return this.all;
    }

    public boolean getAny() {
        return this.any;
    }

    public ExpressionList getTerms() {
        return this.terms;
    }
}

