/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.WhenClauses;

public class CaseExpression
extends Expression {
    IExpression anyExpression;
    WhenClauses whenClauses;
    IExpression elseClause;

    public CaseExpression(IExpression any, WhenClauses whenClauses, IExpression elseExpr) {
        if (whenClauses == null) {
            throw new NullPointerException("whenClauses may not be null.");
        }
        this.anyExpression = any;
        this.whenClauses = whenClauses;
        this.elseClause = elseExpr;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CaseExpression)) {
            return false;
        }
        CaseExpression o = (CaseExpression)other;
        if ((this.whenClauses == null || o.whenClauses == null) && this.whenClauses != o.whenClauses) {
            return false;
        }
        if ((this.anyExpression == null || o.anyExpression == null) && this.anyExpression != o.anyExpression) {
            return false;
        }
        if ((this.elseClause == null || o.elseClause == null) && this.elseClause != o.elseClause) {
            return false;
        }
        if (this.anyExpression != null && !this.anyExpression.equals(o.anyExpression)) {
            return false;
        }
        if (this.whenClauses != null && !this.whenClauses.equals(o.whenClauses)) {
            return false;
        }
        return this.elseClause == null || this.elseClause.equals(o.elseClause);
    }

    @Override
    public int getNbSubExpressions() {
        int nbSubExpressions = 0;
        nbSubExpressions += this.whenClauses.getNbSubExpressions();
        if (this.anyExpression != null) {
            ++nbSubExpressions;
        }
        if (this.elseClause != null) {
            ++nbSubExpressions;
        }
        return nbSubExpressions;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        int nbWhenClauses = this.whenClauses.getNbSubExpressions();
        if (fragmentNb < nbWhenClauses) {
            return this.whenClauses.getSubExpression(fragmentNb);
        }
        fragmentNb -= nbWhenClauses;
        if (this.anyExpression != null) {
            if (fragmentNb == 0) {
                return this.anyExpression;
            }
            --fragmentNb;
        }
        if (this.elseClause != null) {
            if (fragmentNb == 0) {
                return this.elseClause;
            }
            --fragmentNb;
        }
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        int nbWhenClauses = this.whenClauses.getNbSubExpressions();
        if (fragmentNb < nbWhenClauses) {
            this.whenClauses.setSubExpression(fragmentNb, fragment);
            return;
        }
        fragmentNb -= nbWhenClauses;
        if (this.anyExpression != null) {
            if (fragmentNb == 0) {
                this.anyExpression = (IExpression)fragment;
                return;
            }
            --fragmentNb;
        }
        if (this.elseClause != null) {
            if (fragmentNb == 0) {
                this.elseClause = (IExpression)fragment;
                return;
            }
            --fragmentNb;
        }
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        if (this.anyExpression != null) {
            this.anyExpression.optimize(changed);
        }
        this.whenClauses.optimize(changed);
        if (this.elseClause != null) {
            this.elseClause.optimize(changed);
        }
        return this;
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append("CASE ");
        if (null != this.anyExpression) {
            super.appendHelper(buffer, this.anyExpression, context);
        }
        if (this.whenClauses != null) {
            buffer.append(' ');
        }
        super.appendHelper(buffer, this.whenClauses, context);
        if (this.elseClause != null) {
            buffer.append(" ELSE ");
            super.appendHelper(buffer, this.elseClause, context);
        }
        buffer.append(" END");
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.anyExpression != null) {
            result ^= this.anyExpression.hashCode();
        }
        result ^= this.whenClauses.hashCode();
        if (this.elseClause != null) {
            result ^= this.elseClause.hashCode();
        }
        return result;
    }
}

