/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import java.util.Vector;

public class ConcatenateExpression
extends Expression {
    private Vector<IExpression> m_subExpressions = new Vector();

    public void add(IExpression expression) {
        this.m_subExpressions.add(expression);
    }

    @Override
    public int getNbSubExpressions() {
        return this.m_subExpressions.size();
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.m_subExpressions.get(fragmentNb);
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.m_subExpressions.set(fragmentNb, (IExpression)fragment);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        ConcatenateExpression.optimizeExpressionSubtree(this.m_subExpressions, changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        int nb = this.m_subExpressions.size();
        for (int i = 0; i < nb; ++i) {
            if (i != 0) {
                buffer.append(" || ");
            }
            IExpression expr = this.m_subExpressions.get(i);
            this.appendHelper(buffer, expr, context);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ConcatenateExpression)) {
            return false;
        }
        ConcatenateExpression o = (ConcatenateExpression)other;
        return this.m_subExpressions.equals(o.m_subExpressions);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.m_subExpressions != null) {
            result ^= this.m_subExpressions.hashCode();
        }
        return result;
    }
}

