/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Clause;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionTypeValidator;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.ReplaceSubExpression;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

abstract class Expression
extends ExpressionFragment
implements IExpression {
    Expression() {
    }

    @Override
    public IExpression optimize() throws ParseTreeException {
        BooleanValue changed = new BooleanValue(false);
        return this.optimize(changed);
    }

    protected static boolean sameSetHelper(Vector<?> a, Vector<?> b) {
        if (a == b) {
            return true;
        }
        int size = a.size();
        if (size != b.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            IExpression expr = (IExpression)a.get(i);
            if (b.contains(expr)) continue;
            return false;
        }
        return true;
    }

    protected void checkSubexpressionType(ExpressionType type) throws InvalidTypeException {
        Enumeration<IExpression> expressions = this.getSubExpressions();
        while (expressions.hasMoreElements()) {
            IExpression expr = expressions.nextElement();
            ExpressionType subType = expr.getType();
            if (ExpressionTypeValidator.isConsistent(subType, type)) continue;
            throw new InvalidTypeException("Expression type must be: " + (Object)((Object)type));
        }
    }

    @Override
    public ExpressionType getType() throws InvalidTypeException {
        return ExpressionType.UNKNOWN;
    }

    protected static void checkExpressionType(IExpression expr, ExpressionType type) throws InvalidTypeException {
        ExpressionType exprType = expr.getType();
        if (!ExpressionTypeValidator.isConsistent(exprType, type)) {
            throw new InvalidTypeException("Expression type must be: " + (Object)((Object)type));
        }
    }

    @Override
    public IExpression replace(final Hashtable<? extends IExpression, ? extends IExpression> replacements, final BooleanValue changed) throws ParseTreeException {
        IExpression newExpression = (IExpression)ReplaceSubExpression.replace(this, new ReplaceSubExpression.Delegate(){

            @Override
            public IExpressionFragment replace(IExpressionFragment oldExpression) {
                if (replacements.containsKey(oldExpression)) {
                    changed.set(true);
                    return (IExpressionFragment)replacements.get(oldExpression);
                }
                return oldExpression;
            }
        });
        return newExpression;
    }

    @Override
    public final Enumeration<IExpression> getSubExpressions() {
        try {
            return new SubExpressionEnumeration(this);
        }
        catch (ParseTreeException e) {
            throw new Error(e);
        }
    }

    @Override
    public String toString() {
        return "EN: " + this.toString(Locale.ENGLISH);
    }

    @Override
    public String toString(Locale locale) {
        StringBuffer buffer = new StringBuffer();
        this.appendTo(buffer, locale);
        return buffer.toString();
    }

    private static class SubExpressionEnumeration
    implements Enumeration<IExpression> {
        private Stack<FragmentEntry> subExpressionStack = new Stack();

        SubExpressionEnumeration(IExpression expression) throws ParseTreeException {
            FragmentEntry entry = new FragmentEntry(expression);
            this.subExpressionStack.push(entry);
            this.fixStack();
        }

        private void fixStack() throws ParseTreeException {
            boolean changed;
            do {
                if (changed = this.removeCompletedEntries()) continue;
                changed = this.expandTopClause();
            } while (changed);
        }

        private boolean removeCompletedEntries() {
            boolean changed = false;
            if (!this.subExpressionStack.isEmpty()) {
                FragmentEntry top = this.subExpressionStack.peek();
                if (top.index >= top.size) {
                    this.subExpressionStack.pop();
                    changed = true;
                }
            }
            return changed;
        }

        private boolean expandTopClause() throws ParseTreeException {
            boolean changed = false;
            if (!this.subExpressionStack.isEmpty()) {
                FragmentEntry top = this.subExpressionStack.peek();
                IExpressionFragment topFrag = top.fragment.getSubExpression(top.index);
                if (topFrag instanceof Clause) {
                    FragmentEntry newEntry = new FragmentEntry(topFrag);
                    ++top.index;
                    this.subExpressionStack.push(newEntry);
                    changed = true;
                }
            }
            return changed;
        }

        @Override
        public boolean hasMoreElements() {
            boolean isEmpty = this.subExpressionStack.isEmpty();
            return !isEmpty;
        }

        @Override
        public IExpression nextElement() {
            try {
                FragmentEntry top = this.subExpressionStack.peek();
                IExpression topExpression = (IExpression)top.fragment.getSubExpression(top.index);
                ++top.index;
                this.fixStack();
                return topExpression;
            }
            catch (ParseTreeException e) {
                throw new Error(e);
            }
        }

        private static class FragmentEntry {
            IExpressionFragment fragment;
            int size;
            int index;

            public FragmentEntry(IExpressionFragment fragment) {
                this.fragment = fragment;
                this.size = fragment.getNbSubExpressions();
                this.index = 0;
            }
        }
    }
}

