/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionTypeValidator;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.FalseExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.TrueExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.ReplaceSubExpression;

public abstract class IfExpression
extends Expression {
    private IExpression condition;
    private IExpression thenValue;
    private IExpression elseValue;

    public IfExpression(IExpression condition, IExpression thenValue, IExpression elseValue) {
        this.condition = condition;
        this.thenValue = thenValue;
        this.elseValue = elseValue;
    }

    public IExpression getCondition() {
        return this.condition;
    }

    public IExpression getThenValue() {
        return this.thenValue;
    }

    public IExpression getElseValue() {
        return this.elseValue;
    }

    @Override
    public int getNbSubExpressions() {
        if (this.elseValue == null) {
            return 2;
        }
        return 3;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            return this.condition;
        }
        if (fragmentNb == 1) {
            return this.thenValue;
        }
        return this.elseValue;
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            this.condition = (IExpression)fragment;
        } else if (fragmentNb == 1) {
            this.thenValue = (IExpression)fragment;
        } else {
            this.elseValue = (IExpression)fragment;
        }
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    private static IExpression replaceWithFalseInSubExpressions(IExpression subExpressionToChange, IExpression srcExpression, BooleanValue changed) throws ParseTreeException {
        ReplaceDelegate delegate = new ReplaceDelegate(subExpressionToChange, FalseExpression.getInstance(), changed);
        return (IExpression)ReplaceSubExpression.replace(srcExpression, delegate);
    }

    private void optimizeRepeatingCondition(BooleanValue changed) throws ParseTreeException {
        IExpression elseBlock = this.elseValue;
        while (elseBlock != null && elseBlock instanceof IfExpression) {
            IfExpression elseIf = (IfExpression)elseBlock;
            elseIf.condition = IfExpression.replaceWithFalseInSubExpressions(this.condition, elseIf.condition, changed);
            elseBlock = elseIf.elseValue;
        }
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        this.condition = this.condition.optimize(changed);
        this.thenValue = this.thenValue.optimize(changed);
        if (this.elseValue != null) {
            this.elseValue = this.elseValue.optimize(changed);
        }
        if (this.condition instanceof TrueExpression) {
            changed.set(true);
            return this.thenValue;
        }
        if (this.condition instanceof FalseExpression && this.elseValue != null) {
            changed.set(true);
            return this.elseValue;
        }
        this.optimizeRepeatingCondition(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append("IF ");
        this.appendHelper(buffer, this.condition, context);
        buffer.append(" THEN ");
        this.appendHelper(buffer, this.thenValue, context);
        if (this.elseValue != null) {
            buffer.append(" ELSE ");
            this.appendHelper(buffer, this.elseValue, context);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof IfExpression)) {
            return false;
        }
        IfExpression o = (IfExpression)other;
        if (this.condition != o.condition && !this.condition.equals(o.condition)) {
            return false;
        }
        if (this.thenValue != o.thenValue && !this.thenValue.equals(o.thenValue)) {
            return false;
        }
        return this.elseValue == o.elseValue || this.elseValue.equals(o.elseValue);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.condition != null) {
            result ^= this.condition.hashCode();
        }
        if (this.thenValue != null) {
            result ^= this.thenValue.hashCode();
        }
        if (this.elseValue != null) {
            result ^= this.elseValue.hashCode();
        }
        return result;
    }

    @Override
    public ExpressionType getType() throws InvalidTypeException {
        ExpressionType type;
        ExpressionType conditionType = this.condition.getType();
        if (!ExpressionTypeValidator.isConsistent(conditionType, ExpressionType.BOOLEAN)) {
            type = ExpressionType.ERROR;
        } else {
            ExpressionType thenType = this.thenValue.getType();
            ExpressionType elseType = this.elseValue.getType();
            type = ExpressionTypeValidator.mostConcreteType(thenType, elseType);
        }
        return type;
    }

    private static class ReplaceDelegate
    implements ReplaceSubExpression.Delegate {
        private IExpression src;
        private IExpression dest;
        private BooleanValue changed;

        ReplaceDelegate(IExpression src, IExpression dest, BooleanValue changed) {
            this.src = src;
            this.dest = dest;
            this.changed = changed;
        }

        @Override
        public IExpressionFragment replace(IExpressionFragment oldExpression) {
            if (oldExpression.equals(this.src) && !oldExpression.equals(this.dest)) {
                this.changed.set(true);
                return this.dest;
            }
            return oldExpression;
        }
    }
}

