/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionList;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionTypeValidator;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import java.util.Enumeration;

public class InListExpression
extends Expression
implements InExpression {
    private IExpression m_lhs;
    private ExpressionList expressionList;

    public InListExpression() {
    }

    public InListExpression(IExpression lhs, ExpressionList rhs) {
        this.m_lhs = lhs;
        this.expressionList = rhs;
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize() throws ParseTreeException {
        BooleanValue changed = new BooleanValue(false);
        return this.optimize(changed);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        this.m_lhs = this.m_lhs.optimize(changed);
        this.expressionList.optimize(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        this.appendHelper(buffer, this.m_lhs, context);
        buffer.append(" IN (");
        this.appendHelper(buffer, this.expressionList, context);
        buffer.append(")");
    }

    @Override
    public int getNbSubExpressions() {
        return this.expressionList.getNbSubExpressions() + 1;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            return this.m_lhs;
        }
        return this.expressionList.getSubExpression(fragmentNb - 1);
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            this.m_lhs = (IExpression)fragment;
        } else {
            this.expressionList.setSubExpression(fragmentNb - 1, fragment);
        }
    }

    @Override
    public void setLhs(IExpression lhs) throws ParseTreeException {
        this.m_lhs = lhs;
    }

    public void setRhs(ExpressionList rhs) {
        this.expressionList = rhs;
    }

    @Override
    public ExpressionType getType() throws InvalidTypeException {
        ExpressionType type = ExpressionType.UNKNOWN;
        Enumeration<IExpression> subEnumeration = this.getSubExpressions();
        while (subEnumeration.hasMoreElements()) {
            IExpression sub = subEnumeration.nextElement();
            ExpressionType subType = sub.getType();
            type = ExpressionTypeValidator.mostConcreteType(type, subType);
        }
        return type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expressionList == null ? 0 : this.expressionList.hashCode());
        result = 31 * result + (this.m_lhs == null ? 0 : this.m_lhs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InListExpression other = (InListExpression)obj;
        if (this.expressionList == null ? other.expressionList != null : !this.expressionList.equals(other.expressionList)) {
            return false;
        }
        return !(this.m_lhs == null ? other.m_lhs != null : !this.m_lhs.equals(other.m_lhs));
    }

    public IExpression getLhs() {
        return this.m_lhs;
    }

    public ExpressionList getExpressionList() {
        return this.expressionList;
    }
}

