/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionList;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionTypeValidator;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import java.util.Enumeration;

public class InSetExpression
extends Expression {
    private IExpression lhs;
    private ExpressionList rhs;

    public InSetExpression(IExpression lhs, ExpressionList rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        this.lhs = this.lhs.optimize(changed);
        this.rhs.optimize(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        this.appendHelper(buffer, this.lhs, context);
        buffer.append(" IN (");
        this.appendHelper(buffer, this.rhs, context);
        buffer.append(")");
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InSetExpression)) {
            return false;
        }
        InSetExpression o = (InSetExpression)other;
        if (this.lhs != o.lhs && !this.lhs.equals(o.lhs)) {
            return false;
        }
        return this.rhs == o.rhs || this.rhs.equals(o.rhs);
    }

    @Override
    public int getNbSubExpressions() {
        return this.rhs.getNbSubExpressions() + 1;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            return this.lhs;
        }
        return this.rhs.getSubExpression(fragmentNb - 1);
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            this.lhs = (IExpression)fragment;
        } else {
            this.rhs.setSubExpression(fragmentNb - 1, fragment);
        }
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.lhs != null) {
            result ^= this.lhs.hashCode();
        }
        if (this.rhs != null) {
            result ^= this.rhs.hashCode();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExpressionType getType() {
        try {
            IExpression rhsSub;
            ExpressionType rhsSubType;
            ExpressionType lhsType = this.lhs.getType();
            Enumeration<IExpression> rhsSubEnumeration = this.rhs.getListContents();
            do {
                if (rhsSubEnumeration.hasMoreElements()) continue;
                return ExpressionType.BOOLEAN;
            } while (ExpressionTypeValidator.isConsistent(lhsType, rhsSubType = (rhsSub = rhsSubEnumeration.nextElement()).getType()));
            return ExpressionType.ERROR;
        }
        catch (InvalidTypeException e) {
            return ExpressionType.ERROR;
        }
    }

    public IExpression getLhs() {
        return this.lhs;
    }

    public ExpressionList getRhs() {
        return this.rhs;
    }
}

