/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NumericLiteralExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;

public class IntegerLiteralExpression
extends NumericLiteralExpression {
    private long value;

    public IntegerLiteralExpression(String intValue) throws NumberFormatException {
        super(intValue);
        intValue = this.removeLeadingZeros(intValue);
        this.value = Long.decode(intValue);
    }

    IntegerLiteralExpression(int value) {
        super(Integer.toString(value));
        this.value = value;
    }

    IntegerLiteralExpression(long value) {
        super(Long.toString(value));
        this.value = value;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntegerLiteralExpression)) {
            return false;
        }
        IntegerLiteralExpression o = (IntegerLiteralExpression)other;
        return this.value == o.value;
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) {
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append(this.value);
    }

    public long intValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        Long l = new Long(this.value);
        return result ^= l.hashCode();
    }

    String removeLeadingZeros(String input) {
        int i;
        int len = input.length();
        for (i = 0; i < len - 1 && input.charAt(i) == '0'; ++i) {
        }
        return input.substring(i);
    }

    public long getValue() {
        return this.value;
    }
}

