/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ISimpleExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;

public class MovingAggregateExpression
extends Expression
implements ISimpleExpression {
    private String functionName;
    private boolean distinct = false;
    private IExpression expr1;
    private IExpression expr2;
    private IExpression breakClauses;
    private boolean prefilter = false;

    public MovingAggregateExpression(String functionName, boolean distinct, IExpression expr1, IExpression expr2, IExpression breakClauses, boolean prefilter) {
        this.functionName = functionName;
        this.distinct = distinct;
        this.expr1 = expr1;
        this.expr2 = expr2;
        this.breakClauses = breakClauses;
        this.prefilter = prefilter;
    }

    @Override
    public int getNbSubExpressions() {
        int nbSubExpressions = 0;
        if (this.expr1 != null) {
            ++nbSubExpressions;
        }
        if (this.expr2 != null) {
            ++nbSubExpressions;
        }
        if (this.breakClauses != null) {
            ++nbSubExpressions;
        }
        return nbSubExpressions;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (this.expr1 != null) {
            if (fragmentNb == 0) {
                return this.expr1;
            }
            --fragmentNb;
        }
        if (this.expr2 != null) {
            if (fragmentNb == 0) {
                return this.expr2;
            }
            --fragmentNb;
        }
        if (this.breakClauses != null) {
            if (fragmentNb == 0) {
                return this.breakClauses;
            }
            --fragmentNb;
        }
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (this.expr1 != null) {
            if (fragmentNb == 0) {
                this.expr1 = (IExpression)fragment;
                return;
            }
            --fragmentNb;
        }
        if (this.expr2 != null) {
            if (fragmentNb == 0) {
                this.expr2 = (IExpression)fragment;
                return;
            }
            --fragmentNb;
        }
        if (this.breakClauses != null) {
            if (fragmentNb == 0) {
                this.breakClauses = (IExpression)fragment;
                return;
            }
            --fragmentNb;
        }
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        if (this.expr1 != null) {
            this.expr1 = this.expr1.optimize(changed);
        }
        if (this.expr2 != null) {
            this.expr2 = this.expr2.optimize(changed);
        }
        if (this.breakClauses != null) {
            this.breakClauses = this.breakClauses.optimize(changed);
        }
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append(this.functionName);
        buffer.append("(");
        if (this.distinct) {
            buffer.append("DISTINCT ");
        }
        this.appendHelper(buffer, this.expr1, context);
        this.appendListSeparator(buffer, context);
        this.appendHelper(buffer, this.expr2, context);
        buffer.append(" ");
        if (this.breakClauses != null) {
            this.appendHelper(buffer, this.breakClauses, context);
            buffer.append(" ");
        }
        if (this.prefilter) {
            buffer.append("PREFILTER ");
        }
        buffer.append(" )");
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof MovingAggregateExpression)) {
            return false;
        }
        MovingAggregateExpression o = (MovingAggregateExpression)other;
        if (this.functionName != o.functionName && !this.functionName.equals(o.functionName)) {
            return false;
        }
        if (this.distinct != o.distinct) {
            return false;
        }
        if (this.expr1 != o.expr1 && !this.expr1.equals(o.expr1)) {
            return false;
        }
        if (this.expr2 != o.expr2 && !this.expr2.equals(o.expr2)) {
            return false;
        }
        if (this.breakClauses != o.breakClauses && !this.breakClauses.equals(o.breakClauses)) {
            return false;
        }
        return this.prefilter == o.prefilter;
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.functionName != null) {
            result ^= this.functionName.hashCode();
        }
        if (this.expr1 != null) {
            result ^= this.expr1.hashCode();
        }
        if (this.expr2 != null) {
            result ^= this.expr2.hashCode();
        }
        if (this.breakClauses != null) {
            result ^= this.breakClauses.hashCode();
        }
        int booleanValues = 0;
        if (this.distinct) {
            ++booleanValues;
        }
        booleanValues *= 2;
        if (this.prefilter) {
            ++booleanValues;
        }
        Integer booleanValuesObject = new Integer(booleanValues);
        return result ^= booleanValuesObject.hashCode();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public IExpression getExpr1() {
        return this.expr1;
    }

    public IExpression getExpr2() {
        return this.expr2;
    }

    public IExpression getBreakClauses() {
        return this.breakClauses;
    }

    public boolean getPrefilter() {
        return this.prefilter;
    }
}

