/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IntegerLiteralExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvertExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import java.util.Vector;

public class MultiplicativeExpression
extends Expression {
    private Vector<IExpression> m_subExpressions = new Vector();

    public void add(IExpression sub) {
        this.m_subExpressions.add(sub);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        BooleanValue newChanged = new BooleanValue(false);
        do {
            Expression child;
            IExpression ex;
            newChanged.set(false);
            MultiplicativeExpression.optimizeExpressionSubtree(this.m_subExpressions, newChanged);
            int i = 0;
            while (i < this.m_subExpressions.size()) {
                ex = this.m_subExpressions.get(i);
                if (ex instanceof MultiplicativeExpression) {
                    this.m_subExpressions.removeElementAt(i);
                    child = (MultiplicativeExpression)ex;
                    this.m_subExpressions.addAll(i, ((MultiplicativeExpression)child).m_subExpressions);
                    newChanged.set(true);
                    continue;
                }
                ++i;
            }
            i = 0;
            while (i < this.m_subExpressions.size()) {
                ex = this.m_subExpressions.get(i);
                if (!(ex instanceof IntegerLiteralExpression)) {
                    ++i;
                    continue;
                }
                child = (IntegerLiteralExpression)ex;
                if (((IntegerLiteralExpression)child).intValue() == 0L) {
                    changed.set(true);
                    return new IntegerLiteralExpression(0);
                }
                ++i;
            }
            i = 0;
            while (i < this.m_subExpressions.size() && this.m_subExpressions.size() > 1) {
                ex = this.m_subExpressions.get(i);
                if (!(ex instanceof IntegerLiteralExpression)) {
                    ++i;
                    continue;
                }
                child = (IntegerLiteralExpression)ex;
                if (((IntegerLiteralExpression)child).intValue() == 1L) {
                    newChanged.set(true);
                    this.m_subExpressions.remove(i);
                    continue;
                }
                ++i;
            }
            if (this.m_subExpressions.size() == 1) {
                changed.set(true);
                IExpression result = this.m_subExpressions.get(0);
                return result;
            }
            if (!newChanged.get()) continue;
            changed.set(true);
        } while (newChanged.get());
        return this;
    }

    @Override
    public int getNbSubExpressions() {
        return this.m_subExpressions.size();
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.m_subExpressions.get(fragmentNb);
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.m_subExpressions.set(fragmentNb, (IExpression)fragment);
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        int nbElements = this.m_subExpressions.size();
        for (int i = 0; i < nbElements; ++i) {
            IExpression exp = this.m_subExpressions.get(i);
            if (i == 0) {
                this.appendHelper(buffer, exp, context);
                continue;
            }
            if (exp instanceof InvertExpression && i == nbElements - 1) {
                InvertExpression invertExp = (InvertExpression)exp;
                exp = invertExp.getSubExpression();
                buffer.append(" / ");
                this.appendHelper(buffer, exp, context);
                continue;
            }
            buffer.append(" * ");
            this.appendHelper(buffer, exp, context);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof MultiplicativeExpression)) {
            return false;
        }
        MultiplicativeExpression otherExpr = (MultiplicativeExpression)other;
        return MultiplicativeExpression.sameSetHelper(this.m_subExpressions, otherExpr.m_subExpressions);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.m_subExpressions != null) {
            result ^= this.m_subExpressions.hashCode();
        }
        return result;
    }
}

