/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IntegerLiteralExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;

public class NegateExpression
extends Expression {
    private IExpression m_expression;

    public NegateExpression(IExpression subExpression) {
        this.m_expression = subExpression;
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        if (this.m_expression instanceof NegateExpression) {
            changed.set(true);
            NegateExpression child = (NegateExpression)this.m_expression;
            return child.m_expression;
        }
        if (this.m_expression instanceof IntegerLiteralExpression) {
            IntegerLiteralExpression old = (IntegerLiteralExpression)this.m_expression;
            long newInt = -old.intValue();
            changed.set(true);
            return new IntegerLiteralExpression(newInt);
        }
        this.m_expression = this.m_expression.optimize(changed);
        return this;
    }

    @Override
    public int getNbSubExpressions() {
        return 1;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.m_expression;
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.m_expression = (IExpression)fragment;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append(" -");
        this.appendHelper(buffer, this.m_expression, context);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NegateExpression)) {
            return false;
        }
        NegateExpression other = (NegateExpression)o;
        boolean result = this.m_expression.equals(other.m_expression);
        return result;
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.m_expression != null) {
            result ^= this.m_expression.hashCode();
        }
        return result;
    }
}

