/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;

public class RangeExpression
extends Expression {
    private IExpression minimumBound;
    private IExpression maximumBound;

    public RangeExpression() {
        this.minimumBound = null;
        this.maximumBound = null;
    }

    public RangeExpression(IExpression min, IExpression max) {
        this.minimumBound = min;
        this.maximumBound = max;
    }

    @Override
    public int getNbSubExpressions() {
        int nbSubExpressions = 0;
        if (this.minimumBound != null) {
            ++nbSubExpressions;
        }
        if (this.maximumBound != null) {
            ++nbSubExpressions;
        }
        return nbSubExpressions;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (this.minimumBound != null) {
            if (fragmentNb == 0) {
                return this.minimumBound;
            }
            --fragmentNb;
        }
        if (this.maximumBound != null) {
            if (fragmentNb == 0) {
                return this.maximumBound;
            }
            --fragmentNb;
        }
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (this.minimumBound != null) {
            if (fragmentNb == 0) {
                this.minimumBound = (IExpression)fragment;
                return;
            }
            --fragmentNb;
        }
        if (this.maximumBound != null) {
            if (fragmentNb == 0) {
                this.maximumBound = (IExpression)fragment;
                return;
            }
            --fragmentNb;
        }
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        if (this.minimumBound != null) {
            this.minimumBound = this.minimumBound.optimize(changed);
        }
        if (this.maximumBound != null) {
            this.maximumBound = this.maximumBound.optimize(changed);
        }
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        if (this.minimumBound != null) {
            this.appendHelper(buffer, this.minimumBound, context);
        }
        buffer.append(":");
        if (this.maximumBound != null) {
            this.appendHelper(buffer, this.maximumBound, context);
        }
    }

    public void setMinimumBound(IExpression min) {
        this.minimumBound = min;
    }

    public void setMaximumBound(IExpression max) {
        this.maximumBound = max;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.maximumBound == null ? 0 : this.maximumBound.hashCode());
        result = 31 * result + (this.minimumBound == null ? 0 : this.minimumBound.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RangeExpression)) {
            return false;
        }
        RangeExpression other = (RangeExpression)obj;
        if (this.maximumBound == null ? other.maximumBound != null : !this.maximumBound.equals(other.maximumBound)) {
            return false;
        }
        return !(this.minimumBound == null ? other.minimumBound != null : !this.minimumBound.equals(other.minimumBound));
    }

    public IExpression getMinimumBound() {
        return this.minimumBound;
    }

    public IExpression getMaximumBound() {
        return this.maximumBound;
    }
}

