/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import java.util.Vector;

public class SetExpression
extends Expression
implements IExpression {
    private Vector<IExpression> subExpressions = new Vector();

    @Override
    public int getNbSubExpressions() {
        return this.subExpressions.size();
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.subExpressions.get(fragmentNb);
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.subExpressions.setElementAt((IExpression)fragment, fragmentNb);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        ExpressionFragment.optimizeExpressionSubtree(this.subExpressions, changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append("{");
        int nb = this.subExpressions.size();
        for (int i = 0; i < nb; ++i) {
            IExpression expr = this.subExpressions.get(i);
            if (i != 0) {
                this.appendListSeparator(buffer, context);
            }
            this.appendHelper(buffer, expr, context);
        }
        buffer.append("}");
    }

    @Override
    protected boolean needWrapping(IExpressionFragment fragment, ExpressionFragment.AppendContext context) {
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SetExpression)) {
            return false;
        }
        SetExpression o = (SetExpression)other;
        return this.subExpressions == o.subExpressions || this.subExpressions.equals(o.subExpressions);
    }

    public void add(IExpression expr) {
        this.subExpressions.add(expr);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.subExpressions != null) {
            result ^= this.subExpressions.hashCode();
        }
        return result;
    }
}

