/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ISimpleExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.TextualLiteralExpression;

public class TrimFunctionExpression
extends Expression
implements ISimpleExpression {
    private String trimSpec;
    private IExpression matchChar;
    private IExpression stringExp;

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TrimFunctionExpression)) {
            return false;
        }
        TrimFunctionExpression o = (TrimFunctionExpression)other;
        if (!this.trimSpecSame(o)) {
            return false;
        }
        if (!this.matchCharSame(o)) {
            return false;
        }
        return this.stringExp.equals(o.stringExp);
    }

    public void setTrimSpec(String trimSpec) {
        this.trimSpec = trimSpec;
    }

    public void setMatchChar(IExpression matchChar) {
        this.matchChar = matchChar;
    }

    public void setStringExpression(IExpression stringExp) throws ParseTreeException {
        if (stringExp == null) {
            throw new ParseTreeException("stringExp may not be null");
        }
        this.stringExp = stringExp;
    }

    @Override
    public int getNbSubExpressions() {
        int nbSubExpressions = 0;
        if (this.stringExp != null) {
            ++nbSubExpressions;
        }
        if (this.matchChar != null) {
            ++nbSubExpressions;
        }
        return nbSubExpressions;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (this.stringExp != null) {
            if (fragmentNb == 0) {
                return this.stringExp;
            }
            --fragmentNb;
        }
        if (this.matchChar != null) {
            if (fragmentNb == 0) {
                return this.matchChar;
            }
            --fragmentNb;
        }
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (this.stringExp != null) {
            if (fragmentNb == 0) {
                this.stringExp = (IExpression)fragment;
                return;
            }
            --fragmentNb;
        }
        if (this.matchChar != null) {
            if (fragmentNb == 0) {
                this.matchChar = (IExpression)fragment;
                return;
            }
            --fragmentNb;
        }
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        if (this.matchChar != null) {
            this.matchChar = this.matchChar.optimize(changed);
        }
        this.stringExp = this.stringExp.optimize(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append("TRIM ( ");
        if (this.trimSpec != null) {
            buffer.append(this.trimSpec);
            buffer.append(" ");
        }
        if (this.matchChar != null) {
            this.appendHelper(buffer, this.matchChar, context);
        }
        if (this.trimSpec != null || this.matchChar != null) {
            this.appendListSeparator(buffer, context);
        }
        this.appendHelper(buffer, this.stringExp, context);
        buffer.append(")");
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (!this.isDefaultTrimSpec(this.trimSpec)) {
            result ^= this.trimSpec.hashCode();
        }
        if (!this.isDefaultMatchChar(this.matchChar)) {
            result ^= this.matchChar.hashCode();
        }
        if (this.stringExp != null) {
            result ^= this.stringExp.hashCode();
        }
        return result;
    }

    @Override
    public ExpressionType getType() throws InvalidTypeException {
        Expression.checkExpressionType(this.matchChar, ExpressionType.STRING);
        Expression.checkExpressionType(this.stringExp, ExpressionType.STRING);
        return ExpressionType.STRING;
    }

    private boolean trimSpecSame(TrimFunctionExpression other) {
        if (this.trimSpec == other.trimSpec) {
            return true;
        }
        if (this.trimSpec == null) {
            return this.isDefaultTrimSpec(other.trimSpec);
        }
        if (other.trimSpec == null) {
            return this.isDefaultTrimSpec(this.trimSpec);
        }
        return this.trimSpec.compareToIgnoreCase(other.trimSpec) == 0;
    }

    private boolean isDefaultTrimSpec(String trimSpec) {
        boolean result = trimSpec == null ? true : trimSpec.compareToIgnoreCase("BOTH") == 0;
        return result;
    }

    private boolean matchCharSame(TrimFunctionExpression other) {
        if (this.matchChar == other.matchChar) {
            return true;
        }
        if (this.matchChar == null) {
            return this.isDefaultMatchChar(other.matchChar);
        }
        if (other.matchChar == null) {
            return this.isDefaultMatchChar(this.matchChar);
        }
        return this.matchChar.equals(other.matchChar);
    }

    private boolean isDefaultMatchChar(IExpression matchChar) {
        if (matchChar == null) {
            return true;
        }
        if (!(matchChar instanceof TextualLiteralExpression)) {
            return false;
        }
        TextualLiteralExpression strLit = (TextualLiteralExpression)matchChar;
        String strLitValue = strLit.getStringValue();
        return strLitValue.equals("' '");
    }

    public String getTrimSpec() {
        return this.trimSpec;
    }

    public IExpression getMatchChar() {
        return this.matchChar;
    }

    public IExpression getStringExp() {
        return this.stringExp;
    }
}

