/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.LiteralExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NumericLiteralExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Type;

public class TypeInterval
implements Type {
    private Amount from;
    private Amount to;

    public TypeInterval(Amount from, Amount to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeInterval)) {
            return false;
        }
        TypeInterval o = (TypeInterval)other;
        if (this.from != o.from && !this.from.equals(o.from)) {
            return false;
        }
        return this.to == o.to || this.to.equals(o.to);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append("INTERVAL ");
        this.from.appendTo(buffer, context);
        if (this.to != null) {
            buffer.append(" TO ");
            this.to.appendTo(buffer, context);
        }
    }

    public Amount getFrom() {
        return this.from;
    }

    public Amount getTo() {
        return this.to;
    }

    public static class Amount {
        private String unit;
        private NumericLiteralExpression amount;

        public Amount(String unit, NumericLiteralExpression amount) {
            this.unit = unit;
            this.amount = amount;
        }

        String getUnit() {
            return this.unit;
        }

        LiteralExpression getAmount() {
            return this.amount;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Amount)) {
                return false;
            }
            Amount o = (Amount)other;
            if (this.unit != o.unit && !this.unit.equals(o.unit)) {
                return false;
            }
            return this.amount == o.amount || this.amount.equals(o.amount);
        }

        public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
            visitor.accept(this);
        }

        public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
            buffer.append(this.unit);
            buffer.append(" ");
            this.amount.appendTo(buffer, context);
        }
    }
}

