/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Clause;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;

public class WhenThenClause
extends Clause {
    private IExpression conditionExpr;
    private IExpression thenBodyExpr;

    public WhenThenClause(IExpression cond, IExpression thenBody) {
        this.conditionExpr = cond;
        this.thenBodyExpr = thenBody;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WhenThenClause)) {
            return false;
        }
        WhenThenClause o = (WhenThenClause)other;
        if (this.conditionExpr != o.conditionExpr && !this.conditionExpr.equals(o.conditionExpr)) {
            return false;
        }
        return this.thenBodyExpr == o.thenBodyExpr || this.thenBodyExpr.equals(o.thenBodyExpr);
    }

    @Override
    public int getNbSubExpressions() {
        return 2;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            return this.conditionExpr;
        }
        return this.thenBodyExpr;
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            this.conditionExpr = (IExpression)fragment;
        } else {
            this.thenBodyExpr = (IExpression)fragment;
        }
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    public ExpressionType getType() throws InvalidTypeException {
        ExpressionType type;
        try {
            Expression.checkExpressionType(this.conditionExpr, ExpressionType.BOOLEAN);
            type = this.thenBodyExpr.getType();
        }
        catch (InvalidTypeException e) {
            type = ExpressionType.ERROR;
        }
        return type;
    }

    @Override
    Clause optimize(BooleanValue changed) throws ParseTreeException {
        this.conditionExpr = this.conditionExpr.optimize(changed);
        this.thenBodyExpr = this.thenBodyExpr.optimize(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append("WHEN ");
        this.appendHelper(buffer, this.conditionExpr, context);
        buffer.append(" THEN ");
        this.appendHelper(buffer, this.thenBodyExpr, context);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.conditionExpr != null) {
            result = result >> 1 ^ this.conditionExpr.hashCode();
        }
        if (this.thenBodyExpr != null) {
            result = result >> 1 ^ this.thenBodyExpr.hashCode();
        }
        return result;
    }

    public IExpression getConditionExpr() {
        return this.conditionExpr;
    }

    public IExpression getThenBodyExpr() {
        return this.thenBodyExpr;
    }
}

