/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class CrLfFilterReader
extends FilterReader {
    private int lastChar = -1;

    public CrLfFilterReader(Reader in) {
        super(in);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.lastChar == 13) {
            int c = super.read();
            if (c == -1) {
                this.lastChar = -1;
            } else if (c != 13) {
                this.lastChar = c == 10 ? -1 : c;
            }
            return 10;
        }
        if (this.lastChar != -1) {
            this.lastChar = -1;
            return this.lastChar;
        }
        int c = super.read();
        if (c == -1) {
            return c;
        }
        if (c == 13) {
            this.lastChar = c;
            return this.read();
        }
        return c;
    }

    @Override
    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        int charsRead;
        for (charsRead = 0; charsRead < len; ++charsRead) {
            int c = this.read();
            if (c == -1) {
                if (charsRead == 0) {
                    return -1;
                }
                return charsRead;
            }
            cbuf[off + charsRead] = (char)c;
        }
        return charsRead;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long charactersSkipped;
        for (charactersSkipped = 0L; charactersSkipped < n; ++charactersSkipped) {
            int c = this.read();
            if (c != -1) continue;
            return charactersSkipped;
        }
        return charactersSkipped;
    }

    @Override
    public synchronized boolean ready() throws IOException {
        if (this.lastChar != -1 && this.lastChar != 13) {
            return true;
        }
        if (!super.ready()) {
            return false;
        }
        this.lastChar = super.read();
        return this.ready();
    }
}

