/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.oro.io.GlobFilenameFilter;

public class Glob {
    public static File[] listFiles(String pattern) {
        LinkedList<String> patternParts = new LinkedList<String>();
        File pat = new File(pattern);
        while (pat != null) {
            File patternHead;
            String patText;
            if (pat.exists()) {
                patText = pat.toString();
                patternParts.add(patText);
                pat = null;
                continue;
            }
            patText = pat.getName();
            patternParts.add(patText);
            pat = patternHead = pat.getParentFile();
        }
        Vector<File> files = new Vector<File>();
        Glob.getFiles(patternParts, null, files);
        File[] result = new File[files.size()];
        int i = 0;
        Iterator<File> iter = files.iterator();
        while (iter.hasNext()) {
            result[i] = iter.next();
            ++i;
        }
        return result;
    }

    private static void getFiles(List<String> patternParts, File base, Vector<File> files) {
        if (patternParts.isEmpty()) {
            if (base.exists()) {
                files.add(base);
            }
        } else {
            int size = patternParts.size();
            String part = patternParts.remove(size - 1);
            File f = new File(base, part);
            if (f.exists()) {
                Glob.getFiles(patternParts, f, files);
            } else {
                File[] filteredFiles;
                GlobFilenameFilter filter = new GlobFilenameFilter(part);
                if (base == null) {
                    base = new File(System.getProperty("user.dir"));
                }
                if ((filteredFiles = base.listFiles((FileFilter)filter)) != null) {
                    for (int i = 0; i < filteredFiles.length; ++i) {
                        Glob.getFiles(patternParts, filteredFiles[i], files);
                    }
                }
            }
            patternParts.add(part);
        }
    }
}

