/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.io;

import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.io.XslTransformer;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.parser.XsltParseException;
import jd.xml.xslt.result.DomResultBuilder;
import jd.xml.xslt.result.ResultBuilder;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XslTransformerImpl
implements XslTransformer {
    private static WeakHashMap<URL, Stylesheet> cachedStylesheets = new WeakHashMap();

    @Override
    public Document performSingleXsltTransformation(Document sourceDoc, URL xslFile, IConfiguration config) throws Exception {
        return XslTransformerImpl.singleXsltTransformation(sourceDoc, xslFile, config);
    }

    public static Document singleXsltTransformation(Document sourceDoc, URL xslFile, IConfiguration config) throws Exception {
        Stylesheet transform = XslTransformerImpl.createStylesheet(xslFile);
        Document result = XslTransformerImpl.singleXsltTransformation(sourceDoc, transform, config);
        return result;
    }

    public static Document singleXsltTransformation(Document sourceDoc, Document transform, IConfiguration config) throws Exception {
        Stylesheet stylesheet = XslTransformerImpl.createStylesheet(transform);
        Document result = XslTransformerImpl.singleXsltTransformation(sourceDoc, stylesheet, config);
        return result;
    }

    public static Document singleXsltTransformation(Document spec, String scriptName, IConfiguration config) throws Exception {
        URL script = config.getXslScript(scriptName);
        return XslTransformerImpl.singleXsltTransformation(spec, script, config);
    }

    public static Document singleXsltTransformation(Document sourceDoc, Stylesheet transform, IConfiguration config) throws Exception {
        LinkedList<Stylesheet> transforms = new LinkedList<Stylesheet>();
        transforms.addLast(transform);
        Document result = XslTransformerImpl.pipelineStylesheets(sourceDoc, transforms, config);
        return result;
    }

    public static Document pipelineXsltTransformationFiles(Document src, List<File> transformFiles, IConfiguration config) throws IOException {
        if (transformFiles.isEmpty()) {
            return src;
        }
        try {
            Document result;
            LinkedList<Stylesheet> transformSources = new LinkedList<Stylesheet>();
            for (File transformFile : transformFiles) {
                Stylesheet transform = XslTransformerImpl.createStylesheet(transformFile.toURI().toURL());
                transformSources.addLast(transform);
            }
            Document document = result = XslTransformerImpl.pipelineStylesheets(src, transformSources, config);
            return document;
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document pipelineStylesheets(Document src, List<Stylesheet> transforms, IConfiguration config) throws IOException {
        if (transforms.isEmpty()) {
            return src;
        }
        try {
            Document result = null;
            Iterator<Stylesheet> iterTransforms = transforms.iterator();
            while (true) {
                if (!iterTransforms.hasNext()) {
                    return result;
                }
                Stylesheet styleSheet = iterTransforms.next();
                result = (Document)src.cloneNode(false);
                XmlSource xsltSource = XslTransformerImpl.createXmlSource(src);
                XsltResult xsltResult = XslTransformerImpl.createXsltResult(result);
                styleSheet.transform(xsltSource, xsltResult);
                xsltResult.cleanup();
                XmlUtils.writeIntermediateDocument(result, null, config);
                src = result;
            }
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
        catch (XsltException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    private static XmlSource createXmlSource(Document doc) {
        XmlSource result = new XmlSource("file//tmp_in.xml", (Object)doc);
        return result;
    }

    private static XsltResult createXsltResult(Document doc) throws IOException {
        if (doc == null) {
            throw new IOException(new NullPointerException());
        }
        DomResultBuilder resultBuilder = new DomResultBuilder(doc);
        XsltResult result = new XsltResult((ResultBuilder)resultBuilder);
        return result;
    }

    public static Stylesheet createStylesheet(Document transform) throws XsltParseException, SAXException, java.io.IOException {
        String uri = "http://rspecupgrade.cognos.com/" + XslTransformerImpl.class.getName();
        XmlSource source = new XmlSource(uri, (Object)transform);
        Stylesheet styleSheet = new Stylesheet();
        styleSheet.setup(source);
        return styleSheet;
    }

    public static Stylesheet createStylesheet(XmlSource transform) throws XsltParseException, SAXException, java.io.IOException {
        Stylesheet styleSheet = new Stylesheet();
        styleSheet.setup(transform);
        return styleSheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stylesheet createStylesheet(URL transformResource) throws IOException {
        WeakHashMap<URL, Stylesheet> weakHashMap = cachedStylesheets;
        synchronized (weakHashMap) {
            try {
                Stylesheet result = null;
                if (cachedStylesheets.containsKey(transformResource)) {
                    result = cachedStylesheets.get(transformResource);
                }
                if (result == null) {
                    XmlSource transform = new XmlSource(transformResource);
                    result = XslTransformerImpl.createStylesheet(transform);
                    cachedStylesheets.put(transformResource, result);
                }
                Stylesheet stylesheet = result;
                return stylesheet;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (java.io.IOException e) {
                    throw new IOException(e);
                }
                catch (XsltParseException e) {
                    throw new IOException(e);
                }
                catch (SAXException e) {
                    throw new IOException(e);
                }
            }
        }
    }
}

