/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml;

import com.cognos.rspecupgrade.internal.xml.XmlException;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomWalker {
    public static void bottomUpWalkElements(Element elem, Examiner examiner) throws XmlException {
        if (null == elem) {
            throw new XmlException("Element may not be null.");
        }
        DomWalker.bottomUpWalkElementsImpl(elem, examiner);
    }

    private static SearchOrder bottomUpWalkElementsImpl(Element elem, Examiner examiner) throws XmlException {
        SearchOrder result = null;
        Node child = elem.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNextSibling();
            if (child instanceof Element) {
                Element childElem = (Element)child;
                result = DomWalker.bottomUpWalkElementsImpl(childElem, examiner);
                if (result == SearchOrder.stop) {
                    return result;
                }
                if (SearchOrder.ancestorsOnly == result) {
                    nextChild = null;
                }
            }
            child = nextChild;
        }
        result = examiner.examine(elem);
        return result;
    }

    public static void topDownWalkElements(Element elem, Examiner examiner) throws XmlException {
        if (null == elem) {
            throw new XmlException("Element may not be null.");
        }
        DomWalker.topDownWalkElementsImpl(elem, examiner);
    }

    private static SearchOrder topDownWalkElementsImpl(Element elem, Examiner examiner) throws XmlException {
        SearchOrder searchOrder = examiner.examine(elem);
        if (searchOrder == SearchOrder.stop) {
            return searchOrder;
        }
        if (searchOrder.getExamineDescendants()) {
            LinkedList<Node> children = DomWalker.getChildElements(elem);
            for (Element element : children) {
                if (element.getParentNode() == null) continue;
                SearchOrder childSearchOrder = DomWalker.topDownWalkElementsImpl(element, examiner);
                if (childSearchOrder == SearchOrder.stop) {
                    return childSearchOrder;
                }
                if (childSearchOrder.getExamineSiblings()) continue;
                break;
            }
        }
        return searchOrder;
    }

    public static void walkChildrenElements(Element elem, Examiner examiner) throws XmlException {
        if (null == elem) {
            throw new XmlException("Element may not be null.");
        }
        Node child = elem.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNextSibling();
            if (child instanceof Element) {
                Element childElem = (Element)child;
                examiner.examine(childElem);
            }
            child = nextChild;
        }
    }

    public static void walkFollowingSiblingElements(Element elem, Examiner examiner) throws XmlException {
        if (null == elem) {
            throw new XmlException("Element may not be null.");
        }
        LinkedList<Node> toExamine = new LinkedList<Node>();
        for (Node sibling = elem.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (!(sibling instanceof Element)) continue;
            toExamine.addLast(sibling);
        }
        for (Element element : toExamine) {
            if (element.getParentNode() == null) continue;
            examiner.examine(element);
        }
    }

    private static LinkedList<Node> getChildElements(Element elem) {
        LinkedList<Node> children = new LinkedList<Node>();
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            children.addLast(child);
        }
        return children;
    }

    public static interface Examiner {
        public SearchOrder examine(Element var1) throws XmlException;
    }

    public static final class SearchOrder {
        public static SearchOrder stop = new SearchOrder(false, false);
        public static SearchOrder proceed = new SearchOrder(true, true);
        public static SearchOrder descendantsOnly;
        public static SearchOrder ancestorsOnly;
        public static SearchOrder siblingsOnly;
        private boolean examineSiblings;
        private boolean examineAncestorsOrDescendants;

        public boolean getExamineSiblings() {
            return this.examineSiblings;
        }

        public boolean getExamineDescendants() {
            return this.examineAncestorsOrDescendants;
        }

        private SearchOrder(boolean siblings, boolean ancestors) {
            this.examineSiblings = siblings;
            this.examineAncestorsOrDescendants = ancestors;
        }

        static {
            ancestorsOnly = descendantsOnly = new SearchOrder(false, true);
            siblingsOnly = new SearchOrder(true, false);
        }
    }
}

