/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml;

import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceChanger
implements UpgradePipelineElement {
    private String sourceNamespace;
    private String targetNamespace;

    public NamespaceChanger(String _sourceNamespace, String _targetNamespace) {
        this.sourceNamespace = _sourceNamespace;
        this.targetNamespace = _targetNamespace;
    }

    private Attr createTargetAttribute(Attr sourceAttribute, Document targetDoc) {
        Attr targetAttribute;
        if (sourceAttribute.getName().equals("xmlns") && sourceAttribute.getValue().equals(this.sourceNamespace)) {
            targetAttribute = targetDoc.createAttribute("xmlns");
            targetAttribute.setValue(this.targetNamespace);
        } else {
            targetAttribute = (Attr)targetDoc.importNode(sourceAttribute, true);
        }
        return targetAttribute;
    }

    private void copyAttributes(Element source, Element target, Document targetDoc) {
        NamedNodeMap attributes = source.getAttributes();
        int nbAttributes = attributes.getLength();
        for (int i = 0; i < nbAttributes; ++i) {
            Attr sourceAttribute = (Attr)attributes.item(i);
            Attr targetAttribute = this.createTargetAttribute(sourceAttribute, targetDoc);
            target.setAttributeNode(targetAttribute);
        }
    }

    private Node createRenamedNode(Node source, Document targetDoc) throws UpgradeException {
        if (source instanceof Element) {
            Element target = targetDoc.createElementNS(this.targetNamespace, source.getLocalName());
            this.copyAttributes((Element)source, target, targetDoc);
            return target;
        }
        if (source instanceof Attr) {
            Attr sourceAttr = (Attr)source;
            Attr targetAttr = targetDoc.createAttributeNS(this.targetNamespace, source.getLocalName());
            targetAttr.setValue(sourceAttr.getValue());
            return targetAttr;
        }
        throw new UpgradeInternalErrorException("Don't now how to create node " + source.getClass().getName());
    }

    private Set<Attr> findAttributesToRename(Element elem) {
        HashSet<Attr> matchingAttributes = new HashSet<Attr>();
        NamedNodeMap allAttributes = elem.getAttributes();
        int nbAttributes = allAttributes.getLength();
        for (int i = 0; i < nbAttributes; ++i) {
            Attr attr = (Attr)allAttributes.item(i);
            if (!this.sourceNamespace.equals(attr.getNamespaceURI())) continue;
            matchingAttributes.add(attr);
        }
        return matchingAttributes;
    }

    private void changeAttributes(Element source) {
        Set<Attr> attributesToRename = this.findAttributesToRename(source);
        for (Attr sourceAttr : attributesToRename) {
            String name = sourceAttr.getLocalName();
            String value = sourceAttr.getValue();
            source.setAttributeNS(this.targetNamespace, name, value);
        }
    }

    private Node cloneNode(Node source, Node targetParent, Document targetDoc) throws UpgradeException {
        Node targetChild = !this.sourceNamespace.equals(source.getNamespaceURI()) ? targetDoc.importNode(source, false) : this.createRenamedNode(source, targetDoc);
        targetParent.appendChild(targetChild);
        if (targetChild instanceof Element) {
            this.changeAttributes((Element)targetChild);
        }
        return targetChild;
    }

    private void addChildren(Node source, Node target, Document targetDoc) throws UpgradeException {
        for (Node sourceChild = source.getFirstChild(); sourceChild != null; sourceChild = sourceChild.getNextSibling()) {
            if (sourceChild instanceof DocumentType) continue;
            Node targetChild = this.cloneNode(sourceChild, target, targetDoc);
            this.addChildren(sourceChild, targetChild, targetDoc);
        }
    }

    private Document createTargetDoc(Document sourceDoc) throws UpgradeException {
        DocumentType docType = sourceDoc.getDoctype();
        if (docType == null) {
            return (Document)sourceDoc.cloneNode(false);
        }
        try {
            Element sourceRoot = XmlUtils.getRoot(sourceDoc);
            String dtdLocation = docType.getSystemId();
            Document newDoc = XmlUtils.createDocumentWithDtd(sourceRoot.getLocalName(), sourceRoot.getNamespaceURI(), dtdLocation);
            Element newRoot = XmlUtils.getRoot(newDoc);
            newDoc.removeChild(newRoot);
            return newDoc;
        }
        catch (IOException e) {
            throw new UpgradeException(e);
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        return this.upgrade(origSpec);
    }

    public Document upgrade(Document origSpec) throws UpgradeException {
        Document result = this.createTargetDoc(origSpec);
        this.addChildren(origSpec, result, result);
        return result;
    }
}

