/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlChecksumGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlChecksumGeneratorImpl
implements XmlChecksumGenerator {
    @Override
    public String generateChecksum(Document inputDoc, Messages messages, SchemaModel schemaModel) throws Exception {
        if (inputDoc == null) {
            throw new IllegalArgumentException(messages.getString(RspecUpgradeMessage.RSU_CHK_XMLDOC_IS_NULL()));
        }
        try {
            ElementChecksumGenerator examiner = new ElementChecksumGenerator(inputDoc, schemaModel);
            return examiner.getChecksum();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private class ElementChecksumGenerator {
        private MessageDigest md = MessageDigest.getInstance("SHA1");
        private SchemaModel schemaModel = null;

        ElementChecksumGenerator(Document doc, SchemaModel schemaModel) throws Exception {
            this.schemaModel = schemaModel;
            Element root = XmlUtils.getRoot(doc);
            this.addNodeContentsToChecksum(root);
        }

        private void updateMDByBytes(byte[] data, int length) {
            this.md.update(data, 0, length);
        }

        private boolean isComment(Node aNode) {
            return aNode instanceof Comment;
        }

        private boolean isTextNodeAllowed(Node aNode) throws Exception {
            if (aNode == null) {
                return true;
            }
            if (aNode instanceof Text) {
                if (this.schemaModel == null) {
                    return true;
                }
                Element parent = XmlUtils.getParentElement(aNode);
                if (parent != null) {
                    return this.schemaModel.isChildElementAllowed(parent, aNode.getNodeName());
                }
                return true;
            }
            return true;
        }

        private void examineDescendants(Node aNode) throws Exception {
            NodeList children = aNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.addNodeContentsToChecksum(children.item(i));
            }
        }

        private void updateChecksum(String aString) throws Exception {
            if (aString != null) {
                byte[] nsUriBytes = aString.getBytes("UTF-8");
                this.updateMDByBytes(nsUriBytes, nsUriBytes.length);
            }
        }

        private void addNodeContentsToChecksum(Node aNode) throws Exception {
            if (aNode != null && !this.isComment(aNode) && this.isTextNodeAllowed(aNode)) {
                String name = XmlUtils.getName(aNode);
                this.updateChecksum(name);
                String nsUri = aNode.getNamespaceURI();
                this.updateChecksum(nsUri);
                String value = aNode.getNodeValue();
                this.updateChecksum(value);
                this.addAttributesToChecksum(aNode);
                this.examineDescendants(aNode);
            }
        }

        private boolean isAttributeSignificant(Attr attribute) {
            String name = attribute.getName();
            if (name.equals("xmlns")) {
                return false;
            }
            return !name.startsWith("xmlns:");
        }

        private void addAttributesToChecksum(Node node) throws Exception {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                int nbAttributes = attributes.getLength();
                for (int i = 0; i < nbAttributes; ++i) {
                    Attr attribute = (Attr)attributes.item(i);
                    if (!this.isAttributeSignificant(attribute)) continue;
                    this.addNodeContentsToChecksum(attribute);
                }
            }
        }

        public String getChecksum() {
            byte[] mdBytes = this.md.digest();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < mdBytes.length; ++i) {
                sb.append(Integer.toString((mdBytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
    }
}

