/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlChecksumUtils {
    private static final String checksumPrefix = "RSUChecksum-v1:";

    private static boolean isChecksumNode(Node aNode) {
        if (!(aNode instanceof Comment)) {
            return false;
        }
        String value = aNode.getNodeValue();
        if (value == null) {
            return false;
        }
        return value.startsWith(checksumPrefix);
    }

    private static List<Node> getChecksumNodes(Document xmlDoc) throws Exception {
        if (xmlDoc == null) {
            return null;
        }
        Element root = XmlUtils.getRoot(xmlDoc);
        if (root == null) {
            return null;
        }
        ArrayList<Node> checksumNodeList = new ArrayList<Node>();
        for (Node aNode = root.getNextSibling(); aNode != null; aNode = aNode.getNextSibling()) {
            if (!XmlChecksumUtils.isChecksumNode(aNode)) continue;
            checksumNodeList.add(aNode);
        }
        return checksumNodeList;
    }

    public static Node getUniqueChecksumNode(Document xmlDoc, Messages messages) throws Exception {
        if (xmlDoc == null) {
            throw new IllegalArgumentException(messages.getString(RspecUpgradeMessage.RSU_CHK_XMLDOC_IS_NULL()));
        }
        List<Node> checksumNodes = XmlChecksumUtils.getChecksumNodes(xmlDoc);
        int num = checksumNodes.size();
        if (num == 0) {
            return null;
        }
        if (num > 1) {
            throw new XmlException(messages.getString(RspecUpgradeMessage.RSU_CHK_CHKSUM_NOT_UNIQUE()));
        }
        return checksumNodes.get(0);
    }

    public static String getChecksumString(String aString) {
        if (aString == null || aString.length() == 0) {
            return null;
        }
        if (!aString.startsWith(checksumPrefix)) {
            return null;
        }
        return aString.substring(checksumPrefix.length());
    }

    public static String getChecksumStringFromXmlDoc(Document xmlDoc, Messages messages) throws Exception {
        if (xmlDoc == null) {
            throw new IllegalArgumentException(messages.getString(RspecUpgradeMessage.RSU_CHK_XMLDOC_IS_NULL()));
        }
        Node checksumNode = XmlChecksumUtils.getUniqueChecksumNode(xmlDoc, messages);
        if (checksumNode == null) {
            throw new XmlException(messages.getString(RspecUpgradeMessage.RSU_CHK_CHKSUM_NOT_FOUND()));
        }
        String expectedChecksum = XmlChecksumUtils.getChecksumString(checksumNode.getNodeValue());
        return expectedChecksum;
    }

    public static void appendChecksumNode(Document xmlDoc, String checksum, Messages messages) {
        if (xmlDoc == null) {
            throw new IllegalArgumentException(messages.getString(RspecUpgradeMessage.RSU_CHK_XMLDOC_IS_NULL()));
        }
        if (checksum == null || checksum.length() == 0) {
            throw new IllegalArgumentException(messages.getString(RspecUpgradeMessage.RSU_CHK_CHKSUM_STRING_NULLOREMPTY()));
        }
        Comment commentChecksum = xmlDoc.createComment(checksum);
        xmlDoc.appendChild(commentChecksum);
    }

    public static void removeChecksumNode(Document xmlDoc, Messages messages) throws Exception {
        if (xmlDoc == null) {
            throw new IllegalArgumentException(messages.getString(RspecUpgradeMessage.RSU_CHK_XMLDOC_IS_NULL()));
        }
        List<Node> checksumNodes = XmlChecksumUtils.getChecksumNodes(xmlDoc);
        Iterator<Node> it = checksumNodes.iterator();
        while (it.hasNext()) {
            xmlDoc.removeChild(it.next());
        }
    }

    public static String getChecksumPrefix() {
        return checksumPrefix;
    }
}

