/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml;

import com.cognos.rspecupgrade.internal.xml.XmlChecksumGenerator;
import com.cognos.rspecupgrade.internal.xml.XmlChecksumValidator;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import org.w3c.dom.Document;

public class XmlChecksumValidatorImpl
implements XmlChecksumValidator {
    @Override
    public boolean validateChecksum(Document xmlDoc, String expectedChecksum, XmlChecksumGenerator checksumGenerator, Messages messages, SchemaModel schemaModel) throws Exception {
        if (xmlDoc == null) {
            return false;
        }
        if (expectedChecksum == null || expectedChecksum.length() == 0) {
            throw new IllegalArgumentException(messages.getString(RspecUpgradeMessage.RSU_CHK_CHKSUM_STRING_NULLOREMPTY()));
        }
        if (checksumGenerator == null) {
            throw new IllegalArgumentException(messages.getString(RspecUpgradeMessage.RSU_CHK_CHKSUM_GENERATOR_NULL()));
        }
        String generatedChecksum = checksumGenerator.generateChecksum(xmlDoc, messages, schemaModel);
        return expectedChecksum.equals(generatedChecksum);
    }
}

